/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.PatternStage;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryPlan;
import com.hp.hpl.jena.graph.query.SimpleTreeQueryPlan;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;

public class SimpleQueryHandler
implements QueryHandler {
    private Graph graph;

    public SimpleQueryHandler(Graph graph) {
        this.graph = graph;
    }

    public Stage patternStage(Mapping mapping, Graph graph, Triple[] tripleArray) {
        if (tripleArray.length == 1) {
            return new PatternStage(this.graph, mapping, tripleArray);
        }
        final Stage[] stageArray = new Stage[tripleArray.length];
        int n = 0;
        while (n < tripleArray.length) {
            stageArray[n] = this.patternStage(mapping, graph, new Triple[]{tripleArray[n]});
            ++n;
        }
        return new Stage(){

            public Stage connectFrom(Stage stage) {
                int n = 0;
                while (n < stageArray.length) {
                    stageArray[n].connectFrom(stage);
                    stage = stageArray[n];
                    ++n;
                }
                return super.connectFrom(stage);
            }

            public Pipe deliver(Pipe pipe) {
                return stageArray[stageArray.length - 1].deliver(pipe);
            }
        };
    }

    public BindingQueryPlan prepareBindings(Query query, Node[] nodeArray) {
        return new SimpleQueryPlan(this.graph, query, nodeArray);
    }

    public TreeQueryPlan prepareTree(Graph graph) {
        return new SimpleTreeQueryPlan(this.graph, graph);
    }

    public ExtendedIterator objectsFor(Node node, Node node2) {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(node, node2, null);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getObject());
        }
        return WrappedIterator.create(hashSet.iterator());
    }

    public ExtendedIterator subjectsFor(Node node, Node node2) {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(null, node, node2);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getSubject());
        }
        return WrappedIterator.create(hashSet.iterator());
    }
}

