/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Bind;
import com.hp.hpl.jena.graph.query.Bound;
import com.hp.hpl.jena.graph.query.Element;
import com.hp.hpl.jena.graph.query.Fixed;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pattern;
import com.hp.hpl.jena.graph.query.PatternCompiler;
import com.hp.hpl.jena.graph.query.Query;

public final class PatternStageCompiler
implements PatternCompiler {
    public static Pattern[] compile(PatternCompiler patternCompiler, Mapping mapping, Triple[] tripleArray) {
        Pattern[] patternArray = new Pattern[tripleArray.length];
        int n = 0;
        while (n < tripleArray.length) {
            patternArray[n] = PatternStageCompiler.compile(patternCompiler, tripleArray[n], mapping);
            ++n;
        }
        return patternArray;
    }

    private static Pattern compile(PatternCompiler patternCompiler, Triple triple, Mapping mapping) {
        Node node = triple.getSubject();
        Node node2 = triple.getPredicate();
        Node node3 = triple.getObject();
        return new Pattern(PatternStageCompiler.compile(patternCompiler, node, mapping), PatternStageCompiler.compile(patternCompiler, node2, mapping), PatternStageCompiler.compile(patternCompiler, node3, mapping));
    }

    private static Element compile(PatternCompiler patternCompiler, Node node, Mapping mapping) {
        if (node.equals(Query.ANY)) {
            return patternCompiler.any();
        }
        if (node.isVariable()) {
            if (mapping.maps(node)) {
                return patternCompiler.bound(node, mapping.indexOf(node));
            }
            return patternCompiler.bind(node, mapping.newIndex(node));
        }
        return patternCompiler.fixed(node);
    }

    public Element fixed(Node node) {
        return new Fixed(node);
    }

    public Element bound(Node node, int n) {
        return new Bound(n);
    }

    public Element bind(Node node, int n) {
        return new Bind(n);
    }

    public Element any() {
        return Element.ANY;
    }
}

