/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.Vocabulary;
import com.hp.hpl.jena.graph.compose.RDFS;
import com.hp.hpl.jena.graph.compose.RDFSOld;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.MapFiller;
import com.hp.hpl.jena.util.iterator.MapMany;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestRDFS
extends GraphTestBase {
    Graph base;
    RDFSOld derived;
    RDFS inferred;
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$compose$test$TestRDFS;

    public TestRDFS(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$compose$test$TestRDFS == null ? (class$com$hp$hpl$jena$graph$compose$test$TestRDFS = TestRDFS.class$("com.hp.hpl.jena.graph.compose.test.TestRDFS")) : class$com$hp$hpl$jena$graph$compose$test$TestRDFS);
    }

    public void setUp() {
        this.base = GraphTestBase.graphWith("miles commands mercenaries; commands rdfs:domain Leader; commands rdfs:range Troops");
        this.derived = new RDFSOld(this.base);
        this.inferred = new RDFS(this.base);
    }

    public void assertHas(String string, Graph graph, Triple triple) {
        Assert.assertTrue((String)(string + ": must contain " + triple), (boolean)graph.contains(triple));
    }

    public void assertHasnt(String string, Graph graph, Triple triple) {
        Assert.assertTrue((String)(string + ": must not contain " + triple), (!graph.contains(triple) ? 1 : 0) != 0);
    }

    public void assertHas(String string, Graph graph, String string2) {
        this.assertHas(string, graph, GraphTestBase.triple(string2));
    }

    public void assertHasnt(String string, Graph graph, String string2) {
        this.assertHasnt(string, graph, GraphTestBase.triple(string2));
    }

    public void assertHas(Graph graph, Triple triple) {
        Assert.assertTrue((String)("must contain " + triple), (boolean)graph.contains(triple));
    }

    public void assertHasnt(Graph graph, Triple triple) {
        Assert.assertTrue((String)("mustn't contain " + triple), (!graph.contains(triple) ? 1 : 0) != 0);
    }

    public void assertHas(Graph graph, String string) {
        this.assertHas(graph, GraphTestBase.triple(string));
    }

    public void assertHasnt(Graph graph, String string) {
        this.assertHasnt(graph, GraphTestBase.triple(string));
    }

    protected void checkHas(Triple triple) {
        this.assertHas((Graph)this.derived, triple);
    }

    protected void checkHas(String string) {
        this.checkHas(GraphTestBase.triple(string));
    }

    protected void checkHasnt(String string) {
        this.assertHasnt((Graph)this.derived, string);
    }

    protected void add(Triple triple) {
        this.derived.add(triple);
    }

    protected void add(String string) {
        this.add(GraphTestBase.triple(string));
    }

    public void testHasBasis() {
        this.checkHas("miles commands mercenaries");
    }

    public void testAddWorks() {
        Triple triple = GraphTestBase.triple("illyan commands intelligence");
        Triple triple2 = GraphTestBase.triple("cordelia goes shopping");
        Triple triple3 = GraphTestBase.triple("solettas warm planets");
        Triple triple4 = GraphTestBase.triple("pilots have implants");
        this.add(triple);
        this.add(triple2);
        this.add(triple3);
        this.add(triple4);
        this.checkHas(triple);
        this.checkHas(triple2);
        this.checkHas(triple3);
        this.checkHas(triple4);
        this.assertHasnt((Graph)this.derived, "illyan commands mercenaries");
        this.assertHasnt((Graph)this.derived, "pilots warm shopping");
        this.assertHasnt((Graph)this.derived, "spindizzies drive cities");
    }

    public void testRDFSaxioms(String string, Graph graph) {
        this.assertHas(string, graph, "rdfs:Resource rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdfs:Literal rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdfs:Class rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdf:Property rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdf:Seq rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdf:Bag rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdf:Alt rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdf:Statement rdf:type rdfs:Class");
        this.assertHas(string, graph, "rdf:type rdf:type rdf:Property");
        this.assertHas(string, graph, "rdf:type rdfs:domain rdfs:Resource");
        this.assertHas(string, graph, "rdf:type rdfs:range rdfs:Class");
        this.assertHas(string, graph, "rdfs:domain rdf:type rdf:Property");
        this.assertHas(string, graph, "rdfs:domain rdfs:domain rdf:Property");
        this.assertHas(string, graph, "rdfs:domain rdfs:range rdfs:Class");
        this.assertHas(string, graph, "rdfs:range rdf:type rdf:Property");
        this.assertHas(string, graph, "rdfs:range rdfs:domain rdf:Property");
        this.assertHas(string, graph, "rdfs:range rdfs:range rdfs:Class");
        this.assertHas(string, graph, "rdfs:subPropertyOf rdf:type rdf:Property");
        this.assertHas(string, graph, "rdfs:subPropertyOf rdfs:domain rdf:Property");
        this.assertHas(string, graph, "rdfs:subPropertyOf rdfs:range rdf:Property");
        this.assertHas(string, graph, "rdfs:subClassOf rdf:type rdf:Property");
        this.assertHas(string, graph, "rdfs:subClassOf rdfs:domain rdfs:Class");
        this.assertHas(string, graph, "rdfs:subClassOf rdfs:range rdfs:Class");
        this.assertHas(string, graph, "rdf:subject rdf:type rdf:Property");
        this.assertHas(string, graph, "rdf:subject rdfs:domain rdf:Statement");
        this.assertHas(string, graph, "rdf:predicate rdf:type rdf:Property");
        this.assertHas(string, graph, "rdf:predicate rdfs:domain rdf:Statement");
        this.assertHas(string, graph, "rdf:object rdf:type rdf:Property");
        this.assertHas(string, graph, "rdf:object rdfs:domain rdf:Statement");
    }

    public void testRDFSaxioms() {
        this.testRDFSaxioms("old RDFS", this.derived);
        this.testRDFSaxioms("new RDFS", this.inferred);
    }

    private HashSet setFrom(String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public void testSuperClassMapping() {
        this.add("Spinach rdfs:subClassOf Vegetable");
        HashMap hashMap = this.derived.superClasses();
        Assert.assertEquals((String)"", (Object)this.setFrom("Vegetable rdfs:Resource"), hashMap.get(GraphTestBase.node("Spinach")));
    }

    public void testImplicitProperty() {
        this.assertHas("old RDFS", (Graph)this.derived, "commands rdf:type rdf:Property");
        this.assertHas("new RDFS", (Graph)this.inferred, "commands rdf:type rdf:Property");
        this.assertHasnt("old RDFS", (Graph)this.derived, "miles rdf:type rdf:Property");
        this.assertHasnt("new RDFS", (Graph)this.inferred, "miles rdf:type rdf:Property");
    }

    public void testAddSpotsImplicitProperty() {
        this.assertHasnt("old RDFS", (Graph)this.derived, "goes rdf:type rdf:Property");
        this.assertHasnt("new RDFS", (Graph)this.inferred, "goes rdf:type rdf:Property");
        this.add("cordelia goes shopping");
        this.assertHas("old RDFS", (Graph)this.derived, "goes rdf:type rdf:Property");
        this.assertHas("new RDFS", (Graph)this.inferred, "goes rdf:type rdf:Property");
    }

    public void testForResources(String string, Graph graph) {
        this.assertHasnt(string, graph, "unmentioned rdf:type rdfs:Resource");
        this.assertHas(string, graph, "miles rdf:type rdfs:Resource");
        this.assertHas(string, graph, "commands rdf:type rdfs:Resource");
        this.assertHas(string, graph, "mercenaries rdf:type rdfs:Resource");
    }

    public void testForResources() {
        this.testForResources("old RDFS", this.derived);
        this.testForResources("new RDFS", this.inferred);
    }

    public void testSubPropertyTransitive(String string, Graph graph) {
        this.assertHasnt(string, graph, "alpha rdfs:subPropertyOf gamma");
        this.add("alpha rdfs:subPropertyOf beta");
        this.add("beta rdfs:subPropertyOf gamma");
        this.assertHas(string, graph, "alpha rdfs:subPropertyOf beta");
        this.assertHas(string, graph, "beta rdfs:subPropertyOf gamma");
        this.assertHas(string, graph, "alpha rdfs:subPropertyOf gamma");
    }

    public void testSubPropertyTransitive() {
        this.testSubPropertyTransitive("old RDFS", this.derived);
    }

    public void testSubClassTransitive() {
        this.checkHasnt("alpha rdfs:subClassOf gamma");
        this.add("alpha rdfs:subClassOf beta");
        this.add("beta rdfs:subClassOf gamma");
        this.checkHas("alpha rdfs:subClassOf beta");
        this.checkHas("beta rdfs:subClassOf gamma");
        this.checkHas("alpha rdfs:subClassOf gamma");
    }

    public void testDomain() {
        this.checkHas("miles rdf:type Leader");
    }

    private ArrayList toArray(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public void testMultiply() {
        XY[] xYArray = new XY[]{new XY(0, "a"), new XY(1, "b"), new XY(2, "c"), new XY(1, "d"), new XY(2, "e"), new XY(0, "f")};
        List<Object> list = Arrays.asList("b", "c", "c", "d", "e", "e");
        MapFiller mapFiller = new MapFiller(){

            public boolean refill(Object object, ArrayList arrayList) {
                XY xY = (XY)object;
                int n = 0;
                while (n < xY.x) {
                    arrayList.add(xY.y);
                    ++n;
                }
                return true;
            }
        };
        ArrayList arrayList = this.toArray(new MapMany(new CI(Arrays.asList(xYArray).iterator()), mapFiller));
        Assert.assertEquals((String)"multiple value iterator map failed", list, (Object)arrayList);
    }

    public void testDomainExtraction() {
        Graph graph = GraphTestBase.graphWith("bill watches ben; watches rdfs:domain Watcher");
        Triple triple = new Triple(GraphTestBase.node("bill"), Vocabulary.rdfType, GraphTestBase.node("Watcher"));
        ExtendedIterator extendedIterator = RDFSOld.typedByDomain(graph);
        HashSet<Triple> hashSet = new HashSet<Triple>(Arrays.asList(triple));
        HashSet hashSet2 = new HashSet();
        while (extendedIterator.hasNext()) {
            hashSet2.add(extendedIterator.next());
        }
        Assert.assertEquals((String)"simple domain extraction", hashSet, hashSet2);
    }

    public void testRangeExtraction() {
        Graph graph = GraphTestBase.graphWith("bill watches ben; watches rdfs:range Target");
        Triple triple = new Triple(GraphTestBase.node("ben"), Vocabulary.rdfType, GraphTestBase.node("Target"));
        ExtendedIterator extendedIterator = RDFSOld.typedByRange(graph);
        HashSet<Triple> hashSet = new HashSet<Triple>(Arrays.asList(triple));
        HashSet hashSet2 = new HashSet();
        while (extendedIterator.hasNext()) {
            hashSet2.add(extendedIterator.next());
        }
        Assert.assertEquals((String)"simple range extraction", hashSet, hashSet2);
    }

    public void testRange() {
        this.checkHas("mercenaries rdf:type Troops");
    }

    public void testSubclass() {
        this.add("Spinach rdfs:subClassOf Vegetable");
        this.add("Popeye's rdfs:subClassOf Spinach");
        this.add("this rdf:type Spinach");
        this.add("that rdf:type Popeye's");
        GraphTestBase.assertContainsAll("", this.derived, "this rdf:type Vegetable; that rdf:type Vegetable; that rdf:type Spinach");
        GraphTestBase.assertOmits("", this.derived, "this rdf:type Popeye's");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class XY {
        int x;
        String y;

        XY(int n, String string) {
            this.x = n;
            this.y = string;
        }
    }

    private static class CI
    extends NiceIterator
    implements ClosableIterator {
        private Iterator it;

        public CI(Iterator iterator) {
            this.it = iterator;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return this.it.next();
        }

        public void remove() {
            this.it.remove();
        }

        public void close() {
        }
    }
}

