/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.compose.Intersection;
import com.hp.hpl.jena.rdf.model.Model;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestIntersection
extends GraphTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$compose$test$TestIntersection;

    public TestIntersection(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$compose$test$TestIntersection == null ? (class$com$hp$hpl$jena$graph$compose$test$TestIntersection = TestIntersection.class$("com.hp.hpl.jena.graph.compose.test.TestIntersection")) : class$com$hp$hpl$jena$graph$compose$test$TestIntersection);
    }

    public void testIntersection() {
        Graph graph = GraphTestBase.graphWith("x R y; p R q");
        Graph graph2 = GraphTestBase.graphWith("r A s; x R y");
        Intersection intersection = new Intersection(graph, graph2);
        GraphTestBase.assertContains("Intersection", "x R y", intersection);
        GraphTestBase.assertOmits("Intersection", intersection, "p R q");
        GraphTestBase.assertOmits("Intersection", intersection, "r A s");
        if (intersection.size() != 1) {
            Assert.fail((String)"oops: size of intersection is not 1");
        }
        intersection.add(GraphTestBase.triple("cats eat cheese"));
        GraphTestBase.assertContains("Intersection.L", "cats eat cheese", graph);
        GraphTestBase.assertContains("Intersection.R", "cats eat cheese", graph2);
        Graph graph3 = GraphTestBase.graphWith("a pings b; b pings c; c pings a");
        Graph graph4 = GraphTestBase.graphWith("c pings a; b pings c; x captures y");
        Intersection intersection2 = new Intersection(graph3, graph4);
        Model model = GraphTestBase.modelFor(intersection2);
        Model model2 = GraphTestBase.modelFor(graph3);
        model2.remove(model);
        if (!GraphTestBase.modelFor(graph4).isIsomorphicWith(GraphTestBase.modelFor(GraphTestBase.graphWith("c pings a; b pings c; x captures y")))) {
            GraphTestBase.show("oops: R has changed", graph4);
            Assert.fail((String)"");
        }
        if (!model2.isIsomorphicWith(GraphTestBase.modelFor(GraphTestBase.graphWith("a pings b")))) {
            GraphTestBase.show("oops: L is", graph3);
            Assert.fail((String)"oops: mL should be `a pings b`");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

