/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.compose.Delta;
import junit.framework.TestSuite;

public class TestDelta
extends GraphTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$compose$test$TestDelta;

    public TestDelta(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$compose$test$TestDelta == null ? (class$com$hp$hpl$jena$graph$compose$test$TestDelta = TestDelta.class$("com.hp.hpl.jena.graph.compose.test.TestDelta")) : class$com$hp$hpl$jena$graph$compose$test$TestDelta);
    }

    public void testDelta() {
        Graph graph = GraphTestBase.graphWith("x R y");
        GraphTestBase.assertContains("x", "x R y", graph);
        graph.delete(GraphTestBase.triple("x R y"));
        GraphTestBase.assertOmits("x", graph, "x R y");
        Graph graph2 = GraphTestBase.graphWith("x R y; p S q; I like cheese; pins pop balloons");
        Graph graph3 = GraphTestBase.graphWith("x R y; p S q; I like cheese; pins pop balloons");
        Delta delta = new Delta(graph2);
        GraphTestBase.assertContainsAll("Delta", delta, "x R y; p S q; I like cheese; pins pop balloons");
        GraphTestBase.assertContainsAll("Delta", graph2, "x R y; p S q; I like cheese; pins pop balloons");
        delta.add(GraphTestBase.triple("pigs fly winglessly"));
        delta.delete(GraphTestBase.triple("I like cheese"));
        GraphTestBase.assertContainsAll("changed Delta", delta, "x R y; p S q; pins pop balloons; pigs fly winglessly");
        GraphTestBase.assertOmits("changed delta", delta, "I like cheese");
        GraphTestBase.assertContains("delta additions", "pigs fly winglessly", delta.getAdditions());
        GraphTestBase.assertOmits("delta additions", delta.getAdditions(), "I like cheese");
        GraphTestBase.assertContains("delta deletions", "I like cheese", delta.getDeletions());
        GraphTestBase.assertOmits("delta deletions", delta.getDeletions(), "pigs fly winglessly");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

