/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.StandardTripleMatch;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.Vocabulary;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.MapFiller;
import com.hp.hpl.jena.util.iterator.MapMany;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class RDFSOld
extends Dyadic
implements Vocabulary {
    private Graph properties;
    private static final Node XX = Node.createVariable("x");

    public RDFSOld(Graph graph) {
        super(graph, GraphTestBase.graphWith(""));
        this.properties = this.extractProperties(graph);
    }

    private Graph extractProperties(Graph graph) {
        GraphMem graphMem = new GraphMem();
        Query query = new Query();
        Node node = Node.createVariable("?p");
        ExtendedIterator extendedIterator = query.addMatch(Query.ANY, node, Query.ANY).executeBindings(graph, new Node[]{node});
        while (extendedIterator.hasNext()) {
            Domain domain = (Domain)extendedIterator.next();
            Node node2 = (Node)domain.get(0);
            graphMem.add(new Triple(node2, Vocabulary.rdfType, Vocabulary.rdfProperty));
        }
        return graphMem;
    }

    protected void addSubThing(Triple triple, Node node) {
        Node node2 = triple.getPredicate();
        if (node2.equals(node)) {
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            Node node3 = triple.getSubject();
            Node node4 = triple.getObject();
            Query query = new Query();
            Node node5 = Node.createVariable("?x");
            Node node6 = Node.createVariable("?y");
            ExtendedIterator extendedIterator = query.addMatch(node5, node, node6).executeBindings(this.properties, new Node[]{node5, node6});
            while (extendedIterator.hasNext()) {
                Domain domain = (Domain)extendedIterator.next();
                Node node7 = (Node)domain.get(0);
                Node node8 = (Node)domain.get(1);
                if (node8.equals(node3)) {
                    arrayList.add(new Triple(node7, node, node4));
                }
                if (!node4.equals(node7)) continue;
                arrayList.add(new Triple(node3, node, node8));
            }
            int n = 0;
            while (n < arrayList.size()) {
                this.properties.add((Triple)arrayList.get(n));
                ++n;
            }
        }
        this.properties.add(triple);
    }

    protected void addSubProperty(Triple triple) {
        this.addSubThing(triple, Vocabulary.rdfsSubPropertyOf);
    }

    protected void addSubClass(Triple triple) {
        this.addSubThing(triple, Vocabulary.rdfsSubClassOf);
    }

    private HashSet setWithResource() {
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(Vocabulary.rdfsResource);
        return hashSet;
    }

    private void addSuper(HashMap hashMap, Triple triple) {
        Node node = triple.getSubject();
        Node node2 = triple.getObject();
        if (!hashMap.containsKey(node)) {
            hashMap.put(node, this.setWithResource());
        }
        HashSet hashSet = (HashSet)hashMap.get(node);
        hashSet.add(node2);
    }

    public HashMap superClasses() {
        HashMap hashMap = new HashMap();
        ExtendedIterator extendedIterator = this.find(null, Vocabulary.rdfsSubClassOf, null);
        while (extendedIterator.hasNext()) {
            this.addSuper(hashMap, (Triple)extendedIterator.next());
        }
        return hashMap;
    }

    public void add(Triple triple) {
        this.L.add(triple);
        this.addSubProperty(triple);
        this.addSubClass(triple);
        this.properties.add(new Triple(triple.getPredicate(), Vocabulary.rdfType, Vocabulary.rdfProperty));
    }

    public void delete(Triple triple) {
    }

    private boolean wouldMatch(TripleMatch tripleMatch, Node node, Node node2, Node node3) {
        return !(node != null && !tripleMatch.subject(node) || node2 != null && !tripleMatch.predicate(node2) || node3 != null && !tripleMatch.object(node3));
    }

    protected ExtendedIterator getTheseResources(Node node, Node node2, Node node3, Node node4) {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((Domain)object).get(0);
            }
        };
        Query query = new Query();
        return query.addMatch(node2, node3, node4).executeBindings(this.L, new Node[]{node}).mapWith(map1);
    }

    protected ExtendedIterator getObjectResources() {
        Node node = Node.createVariable("o");
        return this.getTheseResources(node, Query.ANY, Query.ANY, node);
    }

    protected ExtendedIterator getSubjectResources() {
        Node node = Node.createVariable("s");
        return this.getTheseResources(node, node, Query.ANY, Query.ANY);
    }

    protected ExtendedIterator mapAsResources(TripleMatch tripleMatch, ExtendedIterator extendedIterator) {
        return extendedIterator.mapWith(new TypeAsResource()).filterKeep(new AcceptTriples(tripleMatch));
    }

    public static Triple typeIt(Domain domain) {
        return new Triple((Node)domain.get(0), Vocabulary.rdfType, (Node)domain.get(1));
    }

    public static ExtendedIterator typedBy(Graph graph, Node node, Node node2, Node node3) {
        Query query = new Query();
        Node node4 = Node.createVariable("p");
        Node node5 = Node.createVariable("t");
        query.addMatch(node, node4, node3);
        query.addMatch(node4, node2, node5);
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return RDFSOld.typeIt((Domain)object);
            }
        };
        return query.executeBindings(graph, new Node[]{XX, node5}).mapWith(map1);
    }

    public static ExtendedIterator typedByDomain(Graph graph) {
        return RDFSOld.typedBy(graph, XX, Vocabulary.rdfsDomain, Query.ANY);
    }

    public static ExtendedIterator typedByRange(Graph graph) {
        return RDFSOld.typedBy(graph, Query.ANY, Vocabulary.rdfsRange, XX);
    }

    public static ExtendedIterator findAllSubclasses(Graph graph, final TripleMatch tripleMatch) {
        TripleMatch tripleMatch2 = new TripleMatch(){

            public Node getSubject() {
                return null;
            }

            public Node getPredicate() {
                return null;
            }

            public Node getObject() {
                return null;
            }

            public boolean subject(Node node) {
                return true;
            }

            public boolean predicate(Node node) {
                return Vocabulary.rdfsSubClassOf.equals(node);
            }

            public boolean object(Node node) {
                return tripleMatch.object(node);
            }

            public boolean triple(Triple triple) {
                return true;
            }

            public boolean matches(Triple triple) {
                return this.subject(triple.getSubject()) && this.predicate(triple.getPredicate()) && this.object(triple.getObject());
            }
        };
        ExtendedIterator extendedIterator = graph.find(tripleMatch2);
        return extendedIterator.mapWith(new Map1(){

            public Object map1(Object object) {
                return ((Triple)object).getSubject();
            }
        });
    }

    private static HashSet asSet(ExtendedIterator extendedIterator) {
        HashSet hashSet = new HashSet();
        while (extendedIterator.hasNext()) {
            hashSet.add(extendedIterator.next());
        }
        return hashSet;
    }

    public ExtendedIterator typedBySubclass(final TripleMatch tripleMatch, Graph graph) {
        final HashMap hashMap = this.superClasses();
        TripleMatch tripleMatch2 = new TripleMatch(){

            public Node getSubject() {
                return null;
            }

            public Node getPredicate() {
                return null;
            }

            public Node getObject() {
                return null;
            }

            public boolean subject(Node node) {
                return tripleMatch.subject(node);
            }

            public boolean predicate(Node node) {
                return Vocabulary.rdfType.equals(node);
            }

            public boolean object(Node node) {
                return hashMap.containsKey(node);
            }

            public boolean triple(Triple triple) {
                return true;
            }

            public boolean matches(Triple triple) {
                return this.subject(triple.getSubject()) && this.predicate(triple.getPredicate()) && this.object(triple.getObject());
            }
        };
        MapFiller mapFiller = new MapFiller(){

            public boolean refill(Object object, ArrayList arrayList) {
                Triple triple = (Triple)object;
                Node node = triple.getSubject();
                Node node2 = triple.getPredicate();
                Node node3 = triple.getObject();
                Iterator iterator = ((HashSet)hashMap.get(node3)).iterator();
                while (iterator.hasNext()) {
                    arrayList.add(new Triple(node, node2, (Node)iterator.next()));
                }
                return true;
            }
        };
        return new MapMany(graph.find(tripleMatch2), mapFiller);
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        ExtendedIterator extendedIterator;
        ExtendedIterator extendedIterator2;
        ExtendedIterator extendedIterator3;
        Object object;
        ExtendedIterator extendedIterator4 = this.properties.find(tripleMatch).andThen(Vocabulary.rdfsAxioms.find(tripleMatch)).andThen(this.L.find(tripleMatch));
        if (this.wouldMatch(tripleMatch, null, Vocabulary.rdfType, null)) {
            if (tripleMatch instanceof StandardTripleMatch) {
                object = new AcceptTriples(tripleMatch);
                extendedIterator3 = RDFSOld.typedByDomain(new Union(this.properties, this.L));
                extendedIterator2 = RDFSOld.typedByRange(new Union(this.properties, this.L));
                extendedIterator = this.typedBySubclass(tripleMatch, new Union(this.properties, this.L));
                ExtendedIterator extendedIterator5 = extendedIterator3.filterKeep((Filter)object).andThen(extendedIterator2.filterKeep((Filter)object));
                extendedIterator4 = extendedIterator4.andThen(extendedIterator5).andThen(extendedIterator.filterKeep((Filter)object));
            } else {
                throw new RuntimeException("only StandardTripleMatch works");
            }
        }
        if (this.wouldMatch(tripleMatch, null, Vocabulary.rdfType, Vocabulary.rdfsResource)) {
            object = this.getSubjectResources();
            extendedIterator3 = this.getObjectResources();
            extendedIterator2 = this.getTheseResources(Query.P, Query.ANY, Query.P, Query.ANY);
            extendedIterator = this.mapAsResources(tripleMatch, object.andThen(extendedIterator3).andThen(extendedIterator2));
            return extendedIterator4.andThen(extendedIterator);
        }
        return extendedIterator4;
    }

    private static class TypeAsResource
    implements Map1 {
        private TypeAsResource() {
        }

        public Object map1(Object object) {
            return new Triple((Node)object, Vocabulary.rdfType, Vocabulary.rdfsResource);
        }
    }

    private static class AcceptTriples
    implements Filter {
        private TripleMatch m;

        public AcceptTriples(TripleMatch tripleMatch) {
            this.m = tripleMatch;
        }

        public boolean accept(Object object) {
            return this.m.matches((Triple)object);
        }
    }
}

