/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.Vocabulary;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class RDFS
extends Dyadic
implements Vocabulary {
    private Graph derived;

    public RDFS(Graph graph) {
        super(graph, GraphTestBase.graphWith(""));
        Union union = new Union(this.L, Vocabulary.rdfsAxioms);
        this.derived = union.union(new Properties(union)).union(new Resources(union));
    }

    public void add(Triple triple) {
        this.derived.add(triple);
    }

    public void delete(Triple triple) {
        throw new UnsupportedOperationException("RDFS::delete");
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.derived.find(tripleMatch);
    }

    public static class Properties
    extends Dyadic {
        public Properties(Graph graph) {
            super(graph, Properties.extractProperties(graph));
        }

        private static Graph extractProperties(Graph graph) {
            GraphMem graphMem = new GraphMem();
            Query query = new Query();
            Node node = Node.createVariable("?p");
            ExtendedIterator extendedIterator = query.addMatch(Query.ANY, node, Query.ANY).executeBindings(graph, new Node[]{node});
            while (extendedIterator.hasNext()) {
                Domain domain = (Domain)extendedIterator.next();
                Node node2 = (Node)domain.get(0);
                graphMem.add(new Triple(node2, Vocabulary.rdfType, Vocabulary.rdfProperty));
            }
            return graphMem;
        }

        public void delete(Triple triple) {
            this.die("Properties::delete");
        }

        public void add(Triple triple) {
            this.die("Properties::add");
        }

        public ExtendedIterator find(TripleMatch tripleMatch) {
            return Properties.extractProperties(this.L).find(tripleMatch);
        }
    }

    public static class Resources
    extends Dyadic {
        public Resources(Graph graph) {
            super(graph, new GraphMem());
        }

        public void delete(Triple triple) {
            this.die("Resources::delete");
        }

        public void add(Triple triple) {
            this.die("Resources::add");
        }

        public Graph extractResources(Graph graph) {
            GraphMem graphMem = new GraphMem();
            ExtendedIterator extendedIterator = graph.find(null, null, null);
            while (extendedIterator.hasNext()) {
                this.addResources(graphMem, (Triple)extendedIterator.next());
            }
            return graphMem;
        }

        private void addResources(Graph graph, Triple triple) {
            this.addResource(graph, triple.getSubject());
            this.addResource(graph, triple.getPredicate());
            this.addResource(graph, triple.getObject());
        }

        private void addResource(Graph graph, Node node) {
            if (node.isURI()) {
                graph.add(new Triple(node, Vocabulary.rdfType, Vocabulary.rdfsResource));
            }
        }

        public ExtendedIterator find(TripleMatch tripleMatch) {
            return this.extractResources(this.L).find(tripleMatch);
        }
    }
}

