/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.HashMap;
import java.util.Iterator;

public class RDFClosure
extends Dyadic
implements Graph {
    static Node RDFtype = GraphTestBase.node("rdf:type");
    static Node RDFproperty = GraphTestBase.node("rdf:Property");
    static Triple typeTriple = new Triple(RDFtype, RDFtype, RDFproperty);

    public RDFClosure(Graph graph) {
        super(graph, null);
    }

    public void add(Triple triple) {
        this.L.add(triple);
    }

    public void delete(Triple triple) {
        throw new RuntimeException("RDFClosure::delete not implemented [yet]");
    }

    private boolean plausible(TripleMatch tripleMatch, Node node) {
        return tripleMatch.subject(node) && tripleMatch.predicate(RDFtype) && tripleMatch.object(RDFproperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClosableIterator findProperties(Graph graph, TripleMatch tripleMatch) {
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        final HashMap<Node, Triple> hashMap = new HashMap<Node, Triple>();
        try {
            if (tripleMatch.matches(typeTriple)) {
                hashMap.put(RDFtype, typeTriple);
            }
            while (extendedIterator.hasNext()) {
                Triple triple;
                Node node = ((Triple)extendedIterator.next()).getPredicate();
                if (hashMap.containsKey(node) || !this.plausible(tripleMatch, node) || !tripleMatch.triple(triple = new Triple(node, RDFtype, RDFproperty))) continue;
                hashMap.put(node, triple);
            }
            Object var8_7 = null;
            extendedIterator.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            extendedIterator.close();
            throw throwable;
        }
        return new NiceIterator(){
            Iterator base;
            {
                this.base = hashMap.values().iterator();
            }

            public boolean hasNext() {
                return this.base.hasNext();
            }

            public Object next() {
                return this.base.next();
            }
        };
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        if (tripleMatch.predicate(RDFtype) && tripleMatch.object(RDFproperty)) {
            return this.L.find(tripleMatch).andThen(this.findProperties(this.L, tripleMatch));
        }
        return this.L.find(tripleMatch);
    }
}

