/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.CompositionBase;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.HashSet;
import java.util.Iterator;

public class MultiUnion
extends Polyadic {
    public MultiUnion() {
    }

    public MultiUnion(Graph[] graphArray) {
        super(graphArray);
    }

    public MultiUnion(Iterator iterator) {
        super(iterator);
    }

    public void add(Triple triple) {
        try {
            this.getBaseGraph().add(triple);
        }
        catch (NullPointerException nullPointerException) {
            throw new RDFException("Tried to add to a union graph that has no component graphs.");
        }
    }

    public void delete(Triple triple) {
        try {
            this.getBaseGraph().delete(triple);
        }
        catch (NullPointerException nullPointerException) {
            throw new RDFException("Tried to delete from a union graph that has no component graphs.");
        }
    }

    public boolean contains(Triple triple) {
        Iterator iterator = this.m_subGraphs.iterator();
        while (iterator.hasNext()) {
            if (!((Graph)iterator.next()).contains(triple)) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        if (this.m_subGraphs.size() == 0) {
            return new NiceIterator();
        }
        HashSet hashSet = new HashSet();
        ExtendedIterator extendedIterator = null;
        Iterator iterator = this.m_subGraphs.iterator();
        while (iterator.hasNext()) {
            ExtendedIterator extendedIterator2 = CompositionBase.recording(CompositionBase.rejecting(((Graph)iterator.next()).find(tripleMatch), hashSet), hashSet);
            ExtendedIterator extendedIterator3 = extendedIterator = extendedIterator == null ? extendedIterator2 : extendedIterator.andThen(extendedIterator2);
        }
        return extendedIterator;
    }
}

