/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.CompositionBase;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class Delta
extends Dyadic
implements Graph {
    private Graph base;

    public Delta(Graph graph) {
        super(new GraphMem(), new GraphMem());
        this.base = graph;
    }

    public Graph getAdditions() {
        return this.L;
    }

    public Graph getDeletions() {
        return this.R;
    }

    public void add(Triple triple) {
        this.L.add(triple);
        this.R.delete(triple);
    }

    public void delete(Triple triple) {
        this.L.delete(triple);
        this.R.add(triple);
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.base.find(tripleMatch).filterDrop(CompositionBase.ifIn(this.R.find(null, null, null))).andThen(this.L.find(tripleMatch));
    }

    public void close() {
        super.close();
        this.base.close();
    }

    public int size() {
        return this.base.size() + this.L.size() - this.R.size();
    }
}

