/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;

public class StandardTripleMatch
implements TripleMatch {
    protected Node subject;
    protected Node predicate;
    protected Node object;

    public StandardTripleMatch(Node node, Node node2, Node node3) {
        this.subject = node;
        this.predicate = node2;
        this.object = node3;
    }

    public boolean subject(Node node) {
        return this.matches(this.subject, node);
    }

    public boolean predicate(Node node) {
        return this.matches(this.predicate, node);
    }

    public boolean object(Node node) {
        return this.matches(this.object, node);
    }

    public boolean triple(Triple triple) {
        return true;
    }

    public boolean matches(Triple triple) {
        return this.subject(triple.getSubject()) && this.predicate(triple.getPredicate()) && this.object(triple.getObject()) && this.triple(triple);
    }

    public String toString() {
        return "<stm " + this.subject + " " + this.predicate + " " + this.object + ">";
    }

    public Node getObject() {
        return this.object;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getSubject() {
        return this.subject;
    }

    protected boolean matches(Node node, Node node2) {
        return node == null || node.sameValueAs(node2);
    }
}

