/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.FragmentMap;
import com.hp.hpl.jena.graph.Fragments;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;
import java.util.Iterator;

public class SimpleReifier
implements Reifier {
    private Graph parent;
    private boolean passing = false;
    private FragmentMap nodeMap;
    private Filter completeFragment = new Filter(){

        public boolean accept(Object object) {
            return SimpleReifier.this.isComplete((Node)object);
        }
    };

    public SimpleReifier(Graph graph, boolean bl) {
        this.parent = graph;
        this.nodeMap = new FragmentMap();
        this.passing = !bl;
    }

    public Graph getParentGraph() {
        return this.parent;
    }

    public Triple getTriple(Node node) {
        Object v = this.nodeMap.get(node);
        return v == null ? null : (v instanceof Triple ? (Triple)v : this.getTriple(node, (Fragments)v));
    }

    private Triple getTriple(Node node, Fragments fragments) {
        return fragments.isComplete() ? this.nodeMap.putTriple(node, fragments.asTriple()) : null;
    }

    public boolean hasTriple(Node node) {
        return this.getTriple(node) != null;
    }

    public ExtendedIterator allNodes() {
        return WrappedIterator.create(this.nodeMap.keySet().iterator()).filterKeep(this.completeFragment);
    }

    private boolean isComplete(Node node) {
        Object v = this.nodeMap.get(node);
        return v instanceof Triple || ((Fragments)v).isComplete();
    }

    public Node reifyAs(Node node, Triple triple) {
        Object v = this.nodeMap.get(node);
        if (v == null) {
            this.nodeMap.putTriple(node, triple);
        } else if (v instanceof Fragments) {
            this.graphAddQuad(this.parent, node, triple);
        } else if (!triple.equals(v)) {
            throw new Reifier.AlreadyReifiedException(node);
        }
        return node;
    }

    public void remove(Node node, Triple triple) {
        Object v = this.nodeMap.get(node);
        if (v instanceof Triple) {
            if (v.equals(triple)) {
                this.nodeMap.remove(node);
            }
        } else {
            this.parentRemoveQuad(node, triple);
        }
    }

    public boolean hasTriple(Triple triple) {
        ExtendedIterator extendedIterator = this.allNodes();
        while (extendedIterator.hasNext()) {
            if (!this.getTriple((Node)extendedIterator.next()).equals(triple)) continue;
            return true;
        }
        return false;
    }

    public boolean handledAdd(Triple triple) {
        int n = Fragments.getFragmentSelector(triple);
        if (this.passing || n < 0) {
            return false;
        }
        this.getFragment(triple).add(n, triple.getObject());
        return true;
    }

    private Fragments getFragment(Triple triple) {
        Node node = triple.getSubject();
        Object v = this.nodeMap.get(node);
        return v instanceof Triple ? this.explode(node, (Triple)v) : (v == null ? this.nodeMap.putFragments(node, new Fragments(node)) : (Fragments)v);
    }

    private Fragments explode(Node node, Triple triple) {
        return this.nodeMap.putFragments(node, new Fragments(node, triple));
    }

    public boolean handledRemove(Triple triple) {
        int n = Fragments.getFragmentSelector(triple);
        if (this.passing || n < 0) {
            return false;
        }
        this.getFragment(triple).remove(n, triple.getObject());
        return true;
    }

    public void remove(Triple triple) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        ExtendedIterator extendedIterator = this.allNodes();
        while (extendedIterator.hasNext()) {
            object = (Node)extendedIterator.next();
            if (!triple.equals(this.getTriple((Node)object))) continue;
            hashSet.add(object);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.remove((Node)object.next(), triple);
        }
    }

    public Graph getHiddenTriples() {
        GraphMem graphMem = new GraphMem();
        ((SimpleReifier)graphMem.getReifier()).passing = true;
        Iterator iterator = this.nodeMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.include(graphMem, (Node)iterator.next());
        }
        return graphMem;
    }

    private void include(Graph graph, Node node) {
        Object v = this.nodeMap.get(node);
        if (v instanceof Triple) {
            this.graphAddQuad(graph, node, (Triple)v);
        } else {
            ((Fragments)v).includeInto(graph);
        }
    }

    private void parentRemoveQuad(Node node, Triple triple) {
        this.parent.delete(new Triple(node, Reifier.type, Reifier.Statement));
        this.parent.delete(new Triple(node, Reifier.subject, triple.getSubject()));
        this.parent.delete(new Triple(node, Reifier.predicate, triple.getPredicate()));
        this.parent.delete(new Triple(node, Reifier.object, triple.getObject()));
    }

    private void graphAddQuad(Graph graph, Node node, Triple triple) {
        graph.add(new Triple(node, Reifier.subject, triple.getSubject()));
        graph.add(new Triple(node, Reifier.predicate, triple.getPredicate()));
        graph.add(new Triple(node, Reifier.object, triple.getObject()));
        graph.add(new Triple(node, Reifier.type, Reifier.Statement));
    }

    public String toString() {
        return "<R " + this.nodeMap + ">";
    }
}

