/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;

public final class LiteralLabel {
    public static boolean enableEagerValidation = false;
    public static boolean enablePlainSameAsString = true;
    private String lexicalForm;
    private Object value;
    private RDFDatatype dtype;
    private String lang;
    private boolean wellformed = true;

    public LiteralLabel(String string, String string2, RDFDatatype rDFDatatype) throws DatatypeFormatException {
        this.lexicalForm = string;
        this.dtype = rDFDatatype;
        String string3 = this.lang = string2 == null ? "" : string2;
        if (rDFDatatype == null) {
            this.value = string;
        } else {
            this.setValue(string);
        }
    }

    public LiteralLabel(String string, String string2) {
        this(string, string2, null);
    }

    public LiteralLabel(Object object, String string, RDFDatatype rDFDatatype) {
        this.dtype = rDFDatatype;
        this.lang = string == null ? "" : string;
        this.value = object;
    }

    public LiteralLabel(String string, Object object, String string2, RDFDatatype rDFDatatype) {
        this(object, string2, rDFDatatype);
        this.lexicalForm = string;
    }

    public LiteralLabel(Object object) {
        this(object, "", TypeMapper.getInstance().getTypeByValue(object));
    }

    public LiteralLabel(String string, String string2, boolean bl) {
        this.lexicalForm = string;
        String string3 = this.lang = string2 == null ? "" : string2;
        if (bl) {
            this.dtype = XMLLiteralType.theXMLLiteralType;
            this.setValue(string);
        } else {
            this.value = string;
            this.dtype = null;
        }
    }

    private void setValue(String string) throws DatatypeFormatException {
        try {
            this.value = this.dtype.parse(string);
            this.wellformed = true;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (enableEagerValidation) {
                datatypeFormatException.fillInStackTrace();
                throw datatypeFormatException;
            }
            this.wellformed = false;
        }
    }

    public boolean isXML() {
        return this.dtype == XMLLiteralType.theXMLLiteralType;
    }

    public String toString() {
        if (this.lexicalForm == null) {
            this.lexicalForm = this.dtype == null ? this.value.toString() : this.dtype.unparse(this.value);
        }
        return this.lexicalForm;
    }

    public String language() {
        return this.lang;
    }

    public Object getValue() throws DatatypeFormatException {
        if (this.wellformed) {
            return this.value;
        }
        throw new DatatypeFormatException(this.lexicalForm, this.dtype, " in getValue()");
    }

    public RDFDatatype getDatatype() {
        return this.dtype;
    }

    public String getDatatypeURI() {
        if (this.dtype == null) {
            return null;
        }
        return this.dtype.getURI();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof LiteralLabel)) {
            return false;
        }
        LiteralLabel literalLabel = (LiteralLabel)object;
        boolean bl2 = this.dtype == null ? literalLabel.dtype == null : (bl = this.dtype.equals(literalLabel.dtype));
        if (this.wellformed) {
            return bl && this.value.equals(literalLabel.value) && this.lang.equalsIgnoreCase(literalLabel.lang);
        }
        return bl && this.lexicalForm.equals(literalLabel.lexicalForm) && this.lang.equalsIgnoreCase(literalLabel.lang);
    }

    public boolean sameValueAs(LiteralLabel literalLabel) {
        if (literalLabel == null) {
            return false;
        }
        if (!this.wellformed) {
            if (!literalLabel.wellformed) {
                return this.lexicalForm.equals(literalLabel.lexicalForm) && this.lang.equalsIgnoreCase(literalLabel.lang);
            }
            return false;
        }
        if (this.dtype == null) {
            if (literalLabel.dtype == null || enablePlainSameAsString && literalLabel.dtype.equals(XSDDatatype.XSDstring)) {
                return this.lexicalForm.equals(literalLabel.lexicalForm) && this.lang.equalsIgnoreCase(literalLabel.lang);
            }
            return false;
        }
        return this.dtype.isEqual(this, literalLabel);
    }

    public int hashCode() {
        return (this.wellformed ? this.value : this.toString()).hashCode();
    }
}

