/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.LiteralLabel;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GraphTestBase
extends TestCase {
    static final String RDFprefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$GraphTestBase;

    public GraphTestBase(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$GraphTestBase == null ? (class$com$hp$hpl$jena$graph$GraphTestBase = GraphTestBase.class$("com.hp.hpl.jena.graph.GraphTestBase")) : class$com$hp$hpl$jena$graph$GraphTestBase);
    }

    public static Node node(String string) {
        if (string.equals("")) {
            throw new RuntimeException("GraphTestBase::node does not accept an empty string as argument");
        }
        char c = string.charAt(0);
        if (c == '\'') {
            return Node.createLiteral(new LiteralLabel(string, "en-UK", false));
        }
        if (Character.isDigit(c)) {
            return Node.createLiteral(new LiteralLabel(string, "nn-NN", false));
        }
        if (c == '_') {
            return Node.createAnon(new AnonId(string));
        }
        if (c == '?') {
            return Node.createVariable(string.substring(1));
        }
        if (c == '&') {
            return Node.createURI("q:" + string.substring(1));
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return Node.createURI("eh:" + string);
        }
        String string2 = string.substring(0, n);
        if (string2.equals("rdf")) {
            return Node.createURI(RDFprefix + string.substring(n + 1));
        }
        return Node.createURI(string);
    }

    public static Model modelFor(Graph graph) {
        return ModelFactory.createModelForGraph(graph);
    }

    public Set iteratorToSet(ClosableIterator closableIterator) {
        HashSet hashSet = new HashSet();
        while (closableIterator.hasNext()) {
            hashSet.add(closableIterator.next());
        }
        return hashSet;
    }

    public Set nodeSet(String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public static void testNodeHelp() {
        Assert.assertTrue((String)"node() making URIs", (boolean)GraphTestBase.node("hello").isURI());
        Assert.assertTrue((String)"node() making literals", (boolean)GraphTestBase.node("123").isLiteral());
        Assert.assertTrue((String)"node() making literals", (boolean)GraphTestBase.node("'hello'").isLiteral());
        Assert.assertTrue((String)"node() making blanks", (boolean)GraphTestBase.node("_x").isBlank());
        Assert.assertTrue((String)"node() making variables", (boolean)GraphTestBase.node("?x").isVariable());
    }

    public static Triple triple(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Node node = GraphTestBase.node(stringTokenizer.nextToken());
        Node node2 = GraphTestBase.node(stringTokenizer.nextToken());
        Node node3 = GraphTestBase.node(stringTokenizer.nextToken());
        return new Triple(node, node2, node3);
    }

    public static Graph graphAdd(Graph graph, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            graph.add(GraphTestBase.triple(stringTokenizer.nextToken()));
        }
        return graph;
    }

    public static Graph graphWith(String string) {
        return GraphTestBase.graphAdd(new GraphMem(), string);
    }

    public static void assertFalse(String string, boolean bl) {
        Assert.assertTrue((String)string, (!bl ? 1 : 0) != 0);
    }

    public static void assertDiffer(String string, Object object, Object object2) {
        GraphTestBase.assertFalse(string, object.equals(object2));
    }

    public static void printGraph(PrintStream printStream, Graph graph) {
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            printStream.println(extendedIterator.next());
        }
    }

    public static void assertEqualsTemplate(String string, Graph graph, String string2) {
        Assert.assertTrue((String)string, (boolean)graph.isIsomorphicWith(GraphTestBase.graphWith(string2)));
    }

    public void assertEquals(String string, Graph graph, Graph graph2) {
        Model model = GraphTestBase.modelFor(graph);
        Model model2 = GraphTestBase.modelFor(graph2);
        Assert.assertTrue((String)(string + ": wanted " + graph + " got " + graph2), (boolean)model.isIsomorphicWith(model2));
    }

    public static void assertContains(String string, String string2, Graph graph) {
        Assert.assertTrue((String)(string + " must contain " + string2), (boolean)graph.contains(GraphTestBase.triple(string2)));
    }

    public static void assertContainsAll(String string, Graph graph, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            GraphTestBase.assertContains(string, stringTokenizer.nextToken(), graph);
        }
    }

    public static void assertOmits(String string, Graph graph, String string2) {
        GraphTestBase.assertFalse(string + " must not contain " + string2, graph.contains(GraphTestBase.triple(string2)));
    }

    public static void assertOmitsAll(String string, Graph graph, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            GraphTestBase.assertOmits(string, graph, stringTokenizer.nextToken());
        }
    }

    public static boolean contains(Graph graph, String string) {
        return graph.contains(GraphTestBase.triple(string));
    }

    public static void show(String string, Graph graph) {
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        System.out.println(string);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            System.out.println("  " + triple.getSubject() + " @" + triple.getPredicate() + " " + triple.getObject());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

