/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMatcher;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.ReifyingCaptureGraph;
import com.hp.hpl.jena.graph.SimpleReifier;
import com.hp.hpl.jena.graph.StandardTripleMatch;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class GraphBase
implements Graph {
    protected Reifier reifier = null;

    public boolean mightContain(Graph graph) {
        return this == graph;
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler(this);
    }

    public void add(Triple triple) {
        throw new UnsupportedOperationException("GraphBase::add");
    }

    public void delete(Triple triple) {
        throw new UnsupportedOperationException("GraphBase::delete");
    }

    public abstract ExtendedIterator find(TripleMatch var1);

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Node node, Node node2, Node node3) {
        ExtendedIterator extendedIterator = this.find(node, node2, node3);
        try {
            boolean bl = extendedIterator.hasNext();
            Object var7_6 = null;
            extendedIterator.close();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            extendedIterator.close();
            throw throwable;
        }
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.find(new StandardTripleMatch(node, node2, node3));
    }

    public void close() {
    }

    public Reifier getReifier() {
        if (this.reifier == null) {
            this.reifier = new SimpleReifier(this, false);
        }
        return this.reifier;
    }

    public int size() {
        throw new UnsupportedOperationException("GraphBase::size");
    }

    public int capabilities() {
        return 0;
    }

    public boolean isIsomorphicWith(Graph graph) {
        return graph != null && GraphMatcher.equals(this, graph);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        String string = "";
        ExtendedIterator extendedIterator = this.find(null, null, null);
        while (extendedIterator.hasNext()) {
            stringBuffer.append(string);
            string = "; ";
            stringBuffer.append(extendedIterator.next());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static Graph withReification(Graph graph) {
        return new ReifyingCaptureGraph(graph);
    }
}

