/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced.test;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.enhanced.test.SPO;
import com.hp.hpl.jena.enhanced.test.TestAllImpl;
import com.hp.hpl.jena.enhanced.test.TestModelImpl;
import com.hp.hpl.jena.enhanced.test.TestNode;
import com.hp.hpl.jena.enhanced.test.TestObjectImpl;
import com.hp.hpl.jena.enhanced.test.TestProperty;
import com.hp.hpl.jena.enhanced.test.TestPropertyImpl;
import com.hp.hpl.jena.enhanced.test.TestSubject;
import com.hp.hpl.jena.enhanced.test.TestSubjectImpl;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.mem.GraphMem;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestPackage
extends GraphTestBase
implements SPO {
    private static final GraphPersonality split = new GraphPersonality();
    private static final GraphPersonality combo = new GraphPersonality();
    private static final GraphPersonality bitOfBoth = new GraphPersonality();
    private static final GraphPersonality broken = new GraphPersonality();
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestObject;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestSubject;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestPackage$Example;

    public TestPackage(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("Enhanced");
        testSuite.addTest((Test)new TestPackage("testSplitBasic"));
        testSuite.addTest((Test)new TestPackage("testComboBasic"));
        testSuite.addTest((Test)new TestPackage("testSplitFollow"));
        testSuite.addTest((Test)new TestPackage("testComboFollow"));
        testSuite.addTest((Test)new TestPackage("testSplitCache"));
        testSuite.addTest((Test)new TestPackage("testComboCache"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothBasic"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothFollow"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothCache"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothSurprise"));
        testSuite.addTest((Test)new TestPackage("testBrokenBasic"));
        testSuite.addTest((Test)new TestPackage("testSimple"));
        return testSuite;
    }

    private static void miniAsSupports(String string, TestNode testNode, Class clazz, boolean bl) {
        Assert.assertTrue((String)(string + ":sanity"), (boolean)(testNode instanceof Polymorphic));
        TestNode testNode2 = (TestNode)((Object)((EnhNode)((Object)testNode)).viewAs(clazz));
        TestNode testNode3 = (TestNode)((Object)((EnhNode)((Object)testNode)).viewAs(clazz));
        Assert.assertTrue((String)(string + ":idempotency"), (testNode2 == testNode3 ? 1 : 0) != 0);
        Assert.assertEquals((String)(string + ":support"), (boolean)bl, (boolean)((EnhNode)((Object)testNode2)).supports(clazz));
    }

    private static void oneNodeAsSupports(String string, TestNode testNode, boolean[] blArray) {
        TestPackage.miniAsSupports(string + "/TestSubject", testNode, class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, blArray[0]);
        TestPackage.miniAsSupports(string + "/TestProperty", testNode, class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, blArray[1]);
        TestPackage.miniAsSupports(string + "/TestObject", testNode, class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, blArray[2]);
    }

    private static void manyNodeAsSupports(String string, TestNode[] testNodeArray, boolean[][] blArray) {
        int n = 0;
        while (n < testNodeArray.length) {
            TestPackage.oneNodeAsSupports(string + "[" + n + "]", testNodeArray[n], blArray[n]);
            ++n;
        }
    }

    private static void basic(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        GraphTestBase.graphAdd(graphMem, "x R y;");
        TestNode[] testNodeArray = new TestNode[]{testModelImpl.aSubject(), testModelImpl.aProperty(), testModelImpl.anObject()};
        TestPackage.manyNodeAsSupports(string + "(a)", testNodeArray, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        GraphTestBase.graphAdd(graphMem, "y R x;");
        TestPackage.manyNodeAsSupports(string + "(b)", testNodeArray, new boolean[][]{{true, false, true}, {false, true, false}, {true, false, true}});
        graphMem.delete(GraphTestBase.triple("x R y"));
        TestPackage.manyNodeAsSupports(string + "(c)", testNodeArray, new boolean[][]{{false, false, true}, {false, true, false}, {true, false, false}});
    }

    private static void canImplement(String string, TestNode testNode, int n, boolean bl) {
        try {
            switch (n) {
                case 1: {
                    testNode.asSubject().aProperty();
                    break;
                }
                case 2: {
                    testNode.asProperty().anObject();
                    break;
                }
                case 3: {
                    testNode.asObject().aSubject();
                }
            }
            Assert.assertTrue((String)"IllegalStateException expected.", (boolean)bl);
        }
        catch (IllegalStateException illegalStateException) {
            GraphTestBase.assertFalse("IllegalStateException at the wrong time.", bl);
        }
    }

    private static void canImplement(String string, TestNode testNode, boolean[] blArray) {
        TestPackage.canImplement(string + "/TestSubject", testNode, 1, blArray[0]);
        TestPackage.canImplement(string + "/TestProperty", testNode, 2, blArray[1]);
        TestPackage.canImplement(string + "/TestObject", testNode, 3, blArray[2]);
    }

    private static void canImplement(String string, TestNode[] testNodeArray, boolean[][] blArray) {
        int n = 0;
        while (n < testNodeArray.length) {
            TestPackage.canImplement(string + "[" + n + "]", testNodeArray[n], blArray[n]);
            ++n;
        }
    }

    private static void follow(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        GraphTestBase.graphAdd(graphMem, "a b c;");
        TestNode[] testNodeArray = new TestNode[]{testModelImpl.aSubject(), testModelImpl.aProperty(), testModelImpl.anObject()};
        TestPackage.canImplement(string + "(a)", testNodeArray, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        GraphTestBase.graphAdd(graphMem, "b a c;");
        TestPackage.canImplement(string + "(b)", testNodeArray, new boolean[][]{{true, true, false}, {true, true, false}, {false, false, true}});
        graphMem.delete(GraphTestBase.triple("a b c"));
        TestPackage.canImplement(string + "(c)", testNodeArray, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        TestPackage.canImplement(string + "(c)", new TestNode[]{testNodeArray[1].asSubject().aProperty(), testNodeArray[2].asObject().aSubject(), testNodeArray[0].asProperty().anObject()}, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        Assert.assertTrue((String)"Model cache test", (testNodeArray[0].asProperty().anObject() == testNodeArray[2] ? 1 : 0) != 0);
    }

    private static void cache(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        GraphTestBase.graphAdd(graphMem, "a b a;");
        Assert.assertTrue((String)"Caching is on", (testModelImpl.aSubject().asObject() == testModelImpl.anObject() ? 1 : 0) != 0);
        testModelImpl.getNodeCacheControl().setEnabled(false);
        GraphTestBase.assertFalse("Caching is off", testModelImpl.aSubject() == testModelImpl.anObject());
    }

    public static void testSplitBasic() {
        TestPackage.basic("Split: ", split);
    }

    public static void testComboBasic() {
        TestPackage.basic("Combo: ", combo);
    }

    public static void testSplitFollow() {
        TestPackage.follow("Split: ", split);
    }

    public static void testComboFollow() {
        TestPackage.follow("Combo: ", combo);
    }

    public static void testSplitCache() {
        TestPackage.cache("Split: ", split);
    }

    public static void testComboCache() {
        TestPackage.cache("Combo: ", combo);
    }

    public static void testBitOfBothBasic() {
        TestPackage.basic("bob: ", bitOfBoth);
    }

    public static void testBitOfBothFollow() {
        TestPackage.follow("bob: ", bitOfBoth);
    }

    public static void testBitOfBothCache() {
        TestPackage.cache("bob: ", bitOfBoth);
    }

    public static void testBitOfBothSurprise() {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, bitOfBoth);
        GraphTestBase.graphAdd(graphMem, "a a a;");
        TestSubject testSubject = testModelImpl.aSubject();
        Assert.assertTrue((String)"BitOfBoth makes subjects using TestSubjectImpl", (boolean)(testSubject instanceof TestSubjectImpl));
        TestProperty testProperty = testSubject.aProperty();
        Assert.assertTrue((String)"BitOfBoth makes properties using TestAllImpl", (boolean)(testProperty instanceof TestAllImpl));
        Assert.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testProperty == testProperty.asSubject() ? 1 : 0) != 0);
        Assert.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testSubject != testProperty.asSubject() ? 1 : 0) != 0);
        Assert.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testSubject.asSubject() != testSubject.asSubject().asProperty().asSubject() ? 1 : 0) != 0);
    }

    public static void testBrokenBasic() {
        try {
            TestPackage.basic("Broken: ", broken);
            Assert.fail((String)"broken is a misconfigured personality, but it wasn't detected.");
        }
        catch (PersonalityConfigException personalityConfigException) {}
    }

    public void testSimple() {
        GraphMem graphMem = new GraphMem();
        Personality personality = BuiltinPersonalities.model.copy().add(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example, Example.factory);
        EnhGraph enhGraph = new EnhGraph(graphMem, personality);
        Node node = Node.createURI("spoo:bar");
        EnhNode enhNode = new EnhNode(Node.createURI("spoo:bar"), enhGraph);
        EnhNode enhNode2 = new EnhNode(Node.createAnon(), enhGraph);
        Assert.assertTrue((String)"URI node can be an Example", (boolean)enhNode.supports(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example));
        GraphTestBase.assertFalse("Blank node cannot be an Example", enhNode2.supports(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        split.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestObjectImpl.factory);
        split.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestSubjectImpl.factory);
        split.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestPropertyImpl.factory);
        combo.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestAllImpl.factory);
        combo.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestAllImpl.factory);
        combo.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestAllImpl.factory);
        bitOfBoth.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestObjectImpl.factory);
        bitOfBoth.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestSubjectImpl.factory);
        bitOfBoth.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestAllImpl.factory);
        broken.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestObjectImpl.factory);
        broken.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestSubjectImpl.factory);
        broken.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestObjectImpl.factory);
    }

    static class Example {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node node, EnhGraph enhGraph) {
                return new EnhNode(node, enhGraph);
            }

            public boolean canWrap(Node node, EnhGraph enhGraph) {
                return node.isURI();
            }
        };

        Example() {
        }
    }
}

