/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;

public class AbstractDateTime {
    protected int[] data;
    protected double fractionalSeconds;
    protected XSSimpleTypeDecl typeDecl;
    protected static AbstractDateTimeDV dtDV;
    protected static final int CY = 0;
    protected static final int MONTH = 1;
    protected static final int DAY = 2;
    protected static final int HOUR = 3;
    protected static final int MINUTE = 4;
    protected static final int SECOND = 5;
    protected static final int MS = 6;
    protected static final int UTC = 7;
    protected static final int HH = 0;
    protected static final int MM = 1;
    public static final short LESS_THAN = -1;
    public static final short EQUAL = 0;
    public static final short GREATER_THAN = 1;
    public static final short INDETERMINATE = 2;

    public AbstractDateTime(Object object, XSSimpleType xSSimpleType) {
        this.data = (int[])object;
        this.extractFractionalSeconds();
        this.typeDecl = (XSSimpleTypeDecl)xSSimpleType;
    }

    public int compare(AbstractDateTime abstractDateTime) {
        return dtDV.compare((Object)this, (Object)abstractDateTime);
    }

    public String toString() {
        return this.typeDecl.getStringValue((Object)this.data);
    }

    protected void extractFractionalSeconds() {
        if (this.data[6] != 0) {
            int n = this.data[6];
            double d = Math.log(n) / 2.302585093;
            int n2 = 1 + (int)(d / 10.0);
            this.fractionalSeconds = (double)n / Math.pow(10.0, n2);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractDateTime) {
            AbstractDateTime abstractDateTime = (AbstractDateTime)object;
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n] != abstractDateTime.data[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.length) {
            n = n << 1 ^ this.data[n2];
            ++n2;
        }
        return n;
    }
}

