/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.LiteralLabel;

public class BaseDatatype
implements RDFDatatype {
    protected String uri;

    public BaseDatatype(String string) {
        this.uri = string;
    }

    public String getURI() {
        return this.uri;
    }

    public String unparse(Object object) {
        return object.toString();
    }

    public Object parse(String string) throws DatatypeFormatException {
        return string;
    }

    public boolean isValid(String string) {
        try {
            this.parse(string);
            return true;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            return false;
        }
    }

    public boolean isValidLiteral(LiteralLabel literalLabel) {
        return this.equals(literalLabel.getDatatype());
    }

    public boolean isValidValue(Object object) {
        return this.isValid(this.unparse(object));
    }

    public boolean isEqual(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        return literalLabel.getDatatype() == literalLabel2.getDatatype() && literalLabel.getValue().equals(literalLabel2.getValue()) && this.langTagCompatible(literalLabel, literalLabel2);
    }

    public boolean langTagCompatible(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        if (literalLabel.language() == null) {
            return literalLabel2.language() == null || literalLabel2.language().equals("");
        }
        return literalLabel.language().equalsIgnoreCase(literalLabel2.language());
    }

    public Class getJavaClass() {
        return null;
    }

    public Object extendedTypeDefinition() {
        return null;
    }

    public String toString() {
        return "Datatype[" + this.uri + (this.getJavaClass() == null ? "" : " -> " + this.getJavaClass()) + "]";
    }
}

