/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DictionaryBasedBreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    public static final int KIND_CHARACTER = 0;
    public static final int KIND_WORD = 1;
    public static final int KIND_LINE = 2;
    public static final int KIND_SENTENCE = 3;
    public static final int KIND_TITLE = 4;
    private static final SoftReference[] iterCache = new SoftReference[5];
    private static ICULocaleService service;
    private static final String[] KIND_NAMES;
    static /* synthetic */ Class class$com$ibm$icu$text$BreakIterator;

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int offset) {
        int pos = this.following(offset);
        while (pos >= offset && pos != -1) {
            pos = this.previous();
        }
        return pos;
    }

    public boolean isBoundary(int offset) {
        if (offset == 0) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 1);
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 2);
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 0);
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 3);
    }

    public static BreakIterator getTitleInstance() {
        return BreakIterator.getTitleInstance(Locale.getDefault());
    }

    public static BreakIterator getTitleInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 4);
    }

    public static Object registerInstance(BreakIterator iter, Locale locale, int kind) {
        try {
            return BreakIterator.getService().registerObject((Object)iter, locale, kind);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("unknown kind: " + kind);
        }
    }

    public static boolean unregister(Object key) {
        if (service != null) {
            return service.unregisterFactory((ICUService.Factory)key);
        }
        return false;
    }

    private static ICULocaleService getService() {
        if (service == null) {
            ICULocaleService newService = new ICULocaleService("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBBreakIteratorFactory() {
                }

                protected Object handleCreate(Locale loc, int kind, ICUService service) {
                    return BreakIterator.access$000(loc, kind);
                }
            }
            newService.registerFactory(new RBBreakIteratorFactory());
            Class clazz = class$com$ibm$icu$text$BreakIterator == null ? (class$com$ibm$icu$text$BreakIterator = BreakIterator.class$("com.ibm.icu.text.BreakIterator")) : class$com$ibm$icu$text$BreakIterator;
            synchronized (clazz) {
                if (service == null) {
                    service = newService;
                }
            }
        }
        return service;
    }

    private static BreakIterator createBreakInstance(Locale locale, int kind) {
        String prefix = KIND_NAMES[kind];
        return BreakIterator.createBreakInstance(locale, kind, prefix + "BreakRules", prefix + "BreakDictionary");
    }

    private static BreakIterator getBreakInstance(Locale where, int kind) {
        BreakIteratorCache cache;
        if (iterCache[kind] != null && (cache = (BreakIteratorCache)iterCache[kind].get()) != null && cache.getLocale().equals(where)) {
            return cache.createBreakInstance();
        }
        BreakIterator result = BreakIterator.createBreakInstance(where, kind);
        BreakIteratorCache cache2 = new BreakIteratorCache(where, result);
        BreakIterator.iterCache[kind] = new SoftReference<BreakIteratorCache>(cache2);
        return result;
    }

    private static BreakIterator createBreakInstance(Locale where, int kind, String rulesName, String dictionaryName) {
        ResourceBundle bundle = ICULocaleData.getResourceBundle("BreakIteratorRules", where);
        String[] classNames = bundle.getStringArray("BreakIteratorClasses");
        String rules = bundle.getString(rulesName);
        if (classNames[kind].equals("RuleBasedBreakIterator")) {
            return new RuleBasedBreakIterator(rules);
        }
        if (classNames[kind].equals("DictionaryBasedBreakIterator")) {
            try {
                Object t = bundle.getObject(dictionaryName);
                URL url = (URL)t;
                InputStream dictionary = url.openStream();
                return new DictionaryBasedBreakIterator(rules, dictionary);
            }
            catch (IOException e) {
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            return new RuleBasedBreakIterator(rules);
        }
        throw new IllegalArgumentException("Invalid break iterator class \"" + classNames[kind] + "\"");
    }

    public static synchronized Locale[] getAvailableLocales() {
        if (service == null) {
            return ICULocaleData.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    static /* synthetic */ BreakIterator access$000(Locale x0, int x1) {
        return BreakIterator.createBreakInstance(x0, x1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        KIND_NAMES = new String[]{"Character", "Word", "Line", "Sentence", "Title"};
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale where;

        BreakIteratorCache(Locale where, BreakIterator iter) {
            this.where = where;
            this.iter = (BreakIterator)iter.clone();
        }

        Locale getLocale() {
            return this.where;
        }

        BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }
    }
}

