/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaBadBooleanException;
import com.hp.hpl.jena.shared.JenaBadURIException;
import com.hp.hpl.jena.shared.JenaBrokenException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.JenaInvalidPropertyURIException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import com.hp.hpl.jena.xmloutput.RDFXMLWriterI;
import com.hp.hpl.jena.xmloutput.impl.Relation;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.XMLChar;

public abstract class BaseXMLWriter
implements RDFXMLWriterI {
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter == null ? (class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter = BaseXMLWriter.class$("com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter")) : class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter));
    String attributeQuoteChar = "\"";
    private Relation nameSpaces = new Relation();
    private Map ns;
    private static Set badRDF;
    int count;
    static String RDFNS;
    private static Perl5Matcher matcher;
    private static Pattern jenaNamespace;
    String xmlBase = null;
    boolean longId = false;
    boolean allowBadURIs = false;
    int tab = 2;
    int width = 60;
    HashMap anonMap = new HashMap();
    int anonCount = 0;
    private static RDFDefaultErrorHandler defaultErrorHandler;
    RDFErrorHandler errorHandler = defaultErrorHandler;
    Boolean showXmlDeclaration = null;
    private Set namespacesNeeded;
    private static final int FAST = 1;
    private static final int START = 2;
    private static final int END = 3;
    private static final int ATTR = 4;
    private static final int FASTATTR = 5;
    public static boolean dbg;
    private URI baseURI;
    private static final char ESCAPE = 'X';
    static final char[] hexchar;
    private Resource[] blockedRules = new Resource[0];
    private int relativeFlags = 29;
    static /* synthetic */ Class class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter;

    String q(String string) {
        return this.attributeQuoteChar + string + this.attributeQuoteChar;
    }

    String qq(String string) {
        return this.q(Util.substituteStandardEntities(string));
    }

    void setupMaps() {
        this.nameSpaces.set11(RDF.getURI(), "rdf");
        this.nameSpaces.set11(RDFS.getURI(), "rdfs");
        this.nameSpaces.set11(DC.getURI(), "dc");
        this.nameSpaces.set11(RSS.getURI(), "rss");
        this.nameSpaces.set11("http://www.daml.org/2001/03/daml+oil.daml#", "daml");
        this.nameSpaces.set11(VCARD.getURI(), "vcard");
        this.nameSpaces.set11("http://www.w3.org/2002/07/owl#", "owl");
    }

    String anonId(Resource resource) {
        if (this.longId) {
            return this.longAnonId(resource);
        }
        return this.shortAnonId(resource);
    }

    private String shortAnonId(Resource resource) {
        String string = (String)this.anonMap.get(resource.getId());
        if (string == null) {
            string = "A" + Integer.toString(this.anonCount++);
            this.anonMap.put(resource.getId(), string);
        }
        return string;
    }

    private String longAnonId(Resource resource) {
        String string = resource.getId().toString();
        if (XMLChar.isValidNCName((String)string)) {
            return string;
        }
        return BaseXMLWriter.escapedId(string);
    }

    void addNameSpace(String string) {
        this.namespacesNeeded.add(string);
    }

    void workOutNamespaces() {
        String string;
        String string2;
        if (this.ns != null) {
            return;
        }
        this.ns = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.namespacesNeeded.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = Util.getProperty("com.hp.hpl.jena.nsprefix." + string2);
            if (string == null || !this.checkPrefix(string) || hashSet.contains(string)) continue;
            this.ns.put(string2, string);
            hashSet.add(string);
        }
        iterator = this.namespacesNeeded.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (this.ns.containsKey(string2)) continue;
            string = null;
            Set set = this.nameSpaces.forward(string2);
            if (set != null) {
                Iterator iterator2 = set.iterator();
                if (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                }
                if (hashSet.contains(string)) {
                    string = null;
                }
            }
            if (string == null) {
                string = "j." + this.count++;
            }
            this.ns.put(string2, string);
            hashSet.add(string);
        }
    }

    private void addNameSpaces(Model model) {
        NsIterator nsIterator = model.listNameSpaces();
        while (nsIterator.hasNext()) {
            this.addNameSpace(nsIterator.nextNs());
        }
    }

    String xmlnsDecl() {
        this.workOutNamespaces();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.ns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("\n    xmlns");
            String string = (String)entry.getValue();
            String string2 = (String)entry.getKey();
            if (!this.allowBadURIs) {
                try {
                    new URI(string2);
                }
                catch (MalformedURIException malformedURIException) {
                    throw new JenaBadURIException("", malformedURIException);
                }
            }
            if (string.length() > 0) {
                stringBuffer.append(":" + string);
            }
            stringBuffer.append("=" + this.qq(string2));
        }
        return stringBuffer.toString();
    }

    boolean isDefaultNamespace(String string) {
        return "".equals(this.ns.get(string));
    }

    String rdfEl(String string) {
        return this.tag(RDFNS, string, 1, true);
    }

    String startElementTag(String string, String string2) {
        return this.tag(string, string2, 2, false);
    }

    String startElementTag(String string) {
        return this.splitTag(string, 2);
    }

    String attributeTag(String string) {
        return this.splitTag(string, 4);
    }

    String attributeTag(String string, String string2) {
        return this.tag(string, string2, 4, false);
    }

    String rdfAt(String string) {
        return this.tag(RDFNS, string, 5, true);
    }

    String endElementTag(String string, String string2) {
        return this.tag(string, string2, 3, false);
    }

    String endElementTag(String string) {
        return this.splitTag(string, 3);
    }

    String splitTag(String string, int n) {
        int n2 = Util.splitNamespace(string);
        if (n2 == string.length()) {
            throw new JenaInvalidPropertyURIException(string);
        }
        return this.tag(string.substring(0, n2), string.substring(n2), n, true);
    }

    String tag(String string, String string2, int n, boolean bl) {
        if (dbg) {
            System.err.println(string + " - " + string2);
        }
        String string3 = (String)this.ns.get(string);
        if (n != 1 && n != 5) {
            if (!bl && !XMLChar.isValidNCName((String)string2)) {
                return this.splitTag(string + string2, n);
            }
            if (string.equals(RDFNS) && badRDF.contains(string2)) {
                logger.warn((Object)("The URI rdf:" + string2 + " cannot be serialized in RDF/XML."));
                throw new JenaInvalidPropertyURIException("rdf:" + string2);
            }
        }
        boolean bl2 = false;
        if (string3 == null) {
            if (!this.allowBadURIs) {
                try {
                    new URI(string);
                }
                catch (MalformedURIException malformedURIException) {
                    throw new JenaException(malformedURIException);
                }
            }
            logger.warn((Object)("Internal error: unexpected QName URI: <" + string + ">.  Fixing up with j.cook.up code."), (Throwable)new JenaBrokenException("unexpected QName URI " + string));
            bl2 = true;
        } else if (string3.length() == 0) {
            if (n == 4 || n == 5) {
                bl2 = true;
            } else {
                return string2;
            }
        }
        if (bl2) {
            string3 = "j.cook.up";
            switch (n) {
                case 4: 
                case 5: {
                    return "xmlns:" + string3 + "=" + this.qq(string) + " " + string3 + ":" + string2;
                }
                case 2: {
                    return string3 + ":" + string2 + " xmlns:" + string3 + "=" + this.qq(string);
                }
                case 3: {
                    break;
                }
                case 1: {
                    logger.fatal((Object)"Unreachable code - reached.");
                    throw new JenaBrokenException("cookup reached final FAST");
                }
            }
        }
        return string3 + ":" + string2;
    }

    public BaseXMLWriter() {
        this.setupMaps();
    }

    public final void write(Model model, OutputStream outputStream, String string) {
        this.write(model, FileUtils.asUTF8(outputStream), string);
    }

    private void primeNamespace(Model model) {
        Map map = model.getNsPrefixMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = this.getPrefixFor(string2);
            if (string3 != null) continue;
            this.setNsPrefix(string, string2);
        }
    }

    public final synchronized void write(Model model, Writer writer, String string) {
        this.primeNamespace(model);
        Model model2 = ModelCom.withHiddenStatements(model);
        this.namespacesNeeded = new HashSet();
        this.ns = null;
        this.count = 0;
        this.addNameSpace(RDF.getURI());
        this.addNameSpaces(model2);
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        if (!Boolean.FALSE.equals(this.showXmlDeclaration)) {
            String string2;
            String string3 = null;
            if (writer instanceof OutputStreamWriter && !(string2 = ((OutputStreamWriter)writer).getEncoding()).equals("UTF8") && !string2.equals("UTF-16")) {
                String string4 = EncodingMap.getJava2IANAMapping((String)string2);
                if (string4 == null) {
                    logger.warn((Object)("IANA name for Java encoding: " + string2 + " is not known. \n" + "   Not including any encoding declaration in the RDF/XML output.\n" + "   It is better to use a FileOutputStream, in place of a FileWriter."));
                } else {
                    string3 = "<?xml version=" + this.q("1.0") + " encoding=" + this.q(string4) + "?>";
                }
            }
            if (string3 == null && this.showXmlDeclaration != null) {
                string3 = "<?xml version=" + this.q("1.0") + "?>";
            }
            if (string3 != null) {
                printWriter.println(string3);
            }
        }
        try {
            if (this.xmlBase == null) {
                this.baseURI = string == null || string.length() == 0 ? null : new URI(string);
                this.writeBody(model2, printWriter, string, false);
            } else {
                this.baseURI = this.xmlBase.length() == 0 ? null : new URI(this.xmlBase);
                this.writeBody(model2, printWriter, this.xmlBase, true);
            }
        }
        catch (MalformedURIException malformedURIException) {
            throw new JenaBadURIException("", malformedURIException);
        }
        printWriter.flush();
    }

    private boolean checkPrefix(String string) {
        if (string.equals("")) {
            return true;
        }
        if (string.toLowerCase().startsWith("xml")) {
            logger.warn((Object)("Namespace prefix '" + string + "' is reserved by XML."));
        } else if (!XMLChar.isValidNCName((String)string)) {
            logger.warn((Object)("'" + string + "' is not a legal namespace prefix."));
        } else if (matcher.matches(string, jenaNamespace)) {
            logger.warn((Object)("Namespace prefix '" + string + "' is reserved by Jena."));
        } else {
            return true;
        }
        return false;
    }

    public final synchronized void setNsPrefix(String string, String string2) {
        if (this.checkPrefix(string)) {
            this.nameSpaces.set11(string2, string);
        }
    }

    public final String getPrefixFor(String string) {
        Set set = this.nameSpaces.backward(string);
        if (set != null && set.size() == 1) {
            return (String)set.iterator().next();
        }
        return null;
    }

    String relativize(String string) {
        try {
            if (this.relativeFlags != 0 && this.baseURI != null) {
                return this.baseURI.relativize(string, this.relativeFlags);
            }
            if (!this.allowBadURIs) {
                new URI(string);
            }
        }
        catch (MalformedURIException malformedURIException) {
            throw new JenaException(malformedURIException);
        }
        return string;
    }

    abstract void writeBody(Model var1, PrintWriter var2, String var3, boolean var4);

    public synchronized RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        if (rDFErrorHandler2 == defaultErrorHandler) {
            rDFErrorHandler2 = null;
        }
        this.errorHandler = rDFErrorHandler == null ? defaultErrorHandler : rDFErrorHandler;
        return rDFErrorHandler2;
    }

    private static String escapedId(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != 'X' && (i == 0 ? XMLChar.isNCNameStart((int)c) : XMLChar.isNCName((int)c))) {
                stringBuffer.append(c);
                continue;
            }
            BaseXMLWriter.escape(stringBuffer, c);
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char n) {
        stringBuffer.append('X');
        int n2 = n;
        do {
            stringBuffer.append(hexchar[n2 & 0xF]);
        } while ((n2 >>= 4) != 0);
        stringBuffer.append('X');
    }

    public final synchronized Object setProperty(String string, Object object) {
        if (string.equalsIgnoreCase("showXmlDeclaration")) {
            String string2 = this.showXmlDeclaration == null ? null : this.showXmlDeclaration.toString();
            if (object == null) {
                this.showXmlDeclaration = null;
            } else if (object instanceof Boolean) {
                this.showXmlDeclaration = (Boolean)object;
            } else if (object instanceof String) {
                String string3 = (String)object;
                if (string3.equalsIgnoreCase("default")) {
                    this.showXmlDeclaration = null;
                }
                if (string3.equalsIgnoreCase("true")) {
                    this.showXmlDeclaration = Boolean.TRUE;
                } else if (string3.equalsIgnoreCase("false")) {
                    this.showXmlDeclaration = Boolean.FALSE;
                } else {
                    throw new JenaBadBooleanException(string3);
                }
            }
            return string2;
        }
        if (string.equalsIgnoreCase("xmlbase")) {
            String string4 = this.xmlBase;
            this.xmlBase = (String)object;
            return string4;
        }
        if (string.equalsIgnoreCase("tab")) {
            Integer n = new Integer(this.tab);
            if (object instanceof Integer) {
                this.tab = (Integer)object;
            } else {
                try {
                    this.tab = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    logger.warn((Object)("Bad value for tab: '" + object + "' [" + exception.getMessage() + "]"));
                }
            }
            return n;
        }
        if (string.equalsIgnoreCase("width")) {
            Integer n = new Integer(this.width);
            if (object instanceof Integer) {
                this.width = (Integer)object;
            } else {
                try {
                    this.width = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    logger.warn((Object)("Bad value for width: '" + object + "' [" + exception.getMessage() + "]"));
                }
            }
            return n;
        }
        if (string.equalsIgnoreCase("longid")) {
            Boolean bl = new Boolean(this.longId);
            this.longId = BaseXMLWriter.toboolean(object);
            return bl;
        }
        if (string.equalsIgnoreCase("attributeQuoteChar")) {
            String string5 = this.attributeQuoteChar;
            if ("\"".equals(object) || "'".equals(object)) {
                this.attributeQuoteChar = (String)object;
            } else {
                logger.warn((Object)("attributeQutpeChar must be either \"\\\"\" or ', not \"" + object + "\""));
            }
            return string5;
        }
        if (string.equalsIgnoreCase("allowBadURIs")) {
            Boolean bl = new Boolean(this.allowBadURIs);
            this.allowBadURIs = BaseXMLWriter.toboolean(object);
            return bl;
        }
        if (string.equalsIgnoreCase("prettyTypes")) {
            return this.setTypes((Resource[])object);
        }
        if (string.equalsIgnoreCase("relativeURIs")) {
            int n = this.relativeFlags;
            this.relativeFlags = URI.str2flags((String)object);
            return URI.flags2str(n);
        }
        if (string.equalsIgnoreCase("blockRules")) {
            return this.setBlockRules(object);
        }
        logger.warn((Object)("Unsupported property: " + string));
        return null;
    }

    private static boolean toboolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf((String)object);
    }

    Resource[] setTypes(Resource[] resourceArray) {
        logger.warn((Object)"prettyTypes is not a property on the Basic RDF/XML writer.");
        return null;
    }

    Resource[] setBlockRules(Object object) {
        Resource[] resourceArray = this.blockedRules;
        this.unblockAll();
        if (object instanceof Resource[]) {
            this.blockedRules = (Resource[])object;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ", ");
            Vector<Resource> vector = new Vector<Resource>();
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("daml:collection")) {
                    vector.add(DAML_OIL.collection);
                    continue;
                }
                vector.add(new ResourceImpl(RDFSyntax.getURI() + string));
            }
            this.blockedRules = new Resource[vector.size()];
            vector.copyInto(this.blockedRules);
        }
        for (int i = 0; i < this.blockedRules.length; ++i) {
            this.blockRule(this.blockedRules[i]);
        }
        return resourceArray;
    }

    abstract void unblockAll();

    abstract void blockRule(Resource var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ARP.initEncoding();
        badRDF = new HashSet();
        RDFNS = RDF.getURI();
        matcher = new Perl5Matcher();
        try {
            jenaNamespace = new Perl5Compiler().compile("j\\.([1-9][0-9]*|cook\\.up)");
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        badRDF.add("RDF");
        badRDF.add("Description");
        badRDF.add("li");
        badRDF.add("about");
        badRDF.add("aboutEach");
        badRDF.add("aboutEachPrefix");
        badRDF.add("ID");
        badRDF.add("nodeID");
        badRDF.add("parseType");
        badRDF.add("datatype");
        badRDF.add("bagID");
        badRDF.add("resource");
        defaultErrorHandler = new RDFDefaultErrorHandler();
        dbg = false;
        hexchar = "0123456789abcdef".toCharArray();
    }
}

