/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.NoSuchElementException;

public class MapFilterIterator
extends NiceIterator
implements ClosableIterator {
    MapFilter f;
    Object current;
    boolean dead;
    ClosableIterator underlying;

    public MapFilterIterator(MapFilter mapFilter, ClosableIterator closableIterator) {
        this.f = mapFilter;
        this.current = null;
        this.dead = false;
        this.underlying = closableIterator;
    }

    public synchronized boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        while (this.underlying.hasNext()) {
            this.current = this.f.accept(this.underlying.next());
            if (this.current == null) continue;
            return true;
        }
        this.current = null;
        this.dead = true;
        return false;
    }

    public void close() {
        this.underlying.close();
    }

    public synchronized void remove() {
        if (this.current != null || this.dead) {
            throw new IllegalStateException("FilterIterator does not permit calls to hasNext between calls to next and remove.");
        }
        this.underlying.remove();
    }

    public synchronized Object next() {
        if (this.hasNext()) {
            Object object = this.current;
            this.current = null;
            return object;
        }
        throw new NoSuchElementException();
    }
}

