/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.TestManifest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestManifestList {
    Model manifest = null;

    public TestManifestList(String string) {
        this.manifest = ModelLoader.loadModel(string);
    }

    public TestManifestList(Model model) {
        this.manifest = model;
    }

    public Model getModel() {
        return this.manifest;
    }

    public TestIterator iterator() {
        return new TestIterator();
    }

    public TestSuite builtTests(ActionProc actionProc) {
        TestSuite testSuite = new TestSuite();
        TestIterator testIterator = this.iterator();
        while (testIterator.hasNext()) {
            TestItem testItem = testIterator.nextItem();
            TestCase testCase = actionProc.createTest(testItem.entry, testItem.action, testItem.result);
            if (testCase == null) continue;
            testSuite.addTest((Test)testCase);
        }
        return testSuite;
    }

    public static void main(String[] stringArray) {
        TestManifestList testManifestList = new TestManifestList("manifest.n3");
        testManifestList.builtTests(new TestPrinter());
    }

    public static class TestPrinter
    implements ActionProc {
        public TestCase createTest(Resource resource, RDFNode rDFNode, RDFNode rDFNode2) {
            String string = "Unknown";
            String string2 = null;
            if (resource.hasProperty(TestManifest.name)) {
                string = resource.getProperty(TestManifest.name).getString();
            }
            if (resource.hasProperty(RDFS.comment)) {
                string2 = resource.getProperty(RDFS.comment).getString();
            }
            String string3 = "unset";
            if (rDFNode != null) {
                string3 = rDFNode instanceof Resource ? "<" + rDFNode + ">" : "\"" + rDFNode + "\"";
            }
            String string4 = "unset";
            if (rDFNode2 != null) {
                string4 = rDFNode2 instanceof Resource ? "<" + rDFNode2 + ">" : "\"" + rDFNode2 + "\"";
            }
            System.out.println("Name: " + string);
            if (string2 != null) {
                System.out.println("Comment: " + string2);
            }
            System.out.println("    " + string3 + " => " + string4);
            System.out.println();
            return null;
        }
    }

    public static interface ActionProc {
        public TestCase createTest(Resource var1, RDFNode var2, RDFNode var3);
    }

    public class TestItem {
        Resource entry;
        String name;
        RDFNode action;
        RDFNode result;

        public Resource getEntry() {
            return this.entry;
        }

        public String getName() {
            return this.name;
        }

        public RDFNode getAction() {
            return this.action;
        }

        public RDFNode getResult() {
            return this.result;
        }
    }

    public class TestIterator
    implements Iterator {
        List entries;
        Iterator iterator;

        TestIterator() {
            this.init();
        }

        public void init() {
            this.entries = new ArrayList();
            StmtIterator stmtIterator = TestManifestList.this.manifest.listStatements(null, RDF.type, TestManifest.Manifest);
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                Resource resource = statement.getSubject();
                StmtIterator stmtIterator2 = resource.listProperties(TestManifest.entries);
                while (stmtIterator2.hasNext()) {
                    Resource resource2 = stmtIterator2.nextStatement().getResource();
                    while (!((Object)resource2).equals(RDF.nil)) {
                        Resource resource3 = resource2.getProperty(RDF.first).getResource();
                        TestItem testItem = new TestItem();
                        testItem.entry = resource3;
                        testItem.name = resource3.hasProperty(TestManifest.name) ? resource3.getProperty(TestManifest.name).getString() : "No name";
                        if (resource3.hasProperty(TestManifest.action)) {
                            testItem.action = resource3.getProperty(TestManifest.action).getObject();
                        }
                        if (resource3.hasProperty(TestManifest.result)) {
                            testItem.result = resource3.getProperty(TestManifest.result).getObject();
                        }
                        this.entries.add(testItem);
                        resource2 = resource2.getProperty(RDF.rest).getResource();
                    }
                }
                stmtIterator2.close();
            }
            stmtIterator.close();
            this.reset();
        }

        public void reset() {
            this.iterator = this.entries.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public TestItem nextItem() {
            Object e = this.iterator.next();
            if (!(e instanceof TestItem)) {
                System.err.println("obj is " + e.getClass().getName());
            }
            return (TestItem)e;
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }
}

