/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveInfGraph;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class TransitiveReasoner
implements Reasoner {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder tbox = null;
    public static Node directSubPropertyOf = ReasonerRegistry.makeDirect(RDFS.subPropertyOf.getNode());
    public static Node directSubClassOf = ReasonerRegistry.makeDirect(RDFS.subClassOf.getNode());
    public static Node subPropertyOf = RDFS.subPropertyOf.getNode();
    public static Node subClassOf = RDFS.subClassOf.getNode();

    public TransitiveReasoner() {
        this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
        this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
    }

    protected TransitiveReasoner(Finder finder, TransitiveGraphCache transitiveGraphCache, TransitiveGraphCache transitiveGraphCache2) {
        this.tbox = finder;
        this.subClassCache = transitiveGraphCache;
        this.subPropertyCache = transitiveGraphCache2;
    }

    public Model getCapabilities() {
        return TransitiveReasonerFactory.theInstance().getCapabilities();
    }

    public boolean supportsProperty(Property property) {
        ReasonerFactory reasonerFactory = TransitiveReasonerFactory.theInstance();
        Model model = reasonerFactory.getCapabilities();
        Resource resource = model.getResource(reasonerFactory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        return this.bindSchema(new FGraph(graph));
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(new FGraph(model.getGraph()));
    }

    Reasoner bindSchema(Finder finder) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
        TransitiveGraphCache transitiveGraphCache2 = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
        TransitiveEngine.cacheSubPropUtility(finder, transitiveGraphCache2);
        TransitiveEngine.cacheSubClassUtility(finder, transitiveGraphCache2, transitiveGraphCache);
        return new TransitiveReasoner(finder, transitiveGraphCache, transitiveGraphCache2);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        return new TransitiveInfGraph(graph, this);
    }

    public void setDerivationLogging(boolean bl) {
    }

    public void setParameter(String string, Object object) {
        throw new IllegalParameterException(string);
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public Finder getTbox() {
        return this.tbox;
    }
}

