/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestRDFSReasoners
extends TestCase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$test$TestReasoners == null ? (class$com$hp$hpl$jena$reasoner$test$TestReasoners = TestRDFSReasoners.class$("com.hp.hpl.jena.reasoner.test.TestReasoners")) : class$com$hp$hpl$jena$reasoner$test$TestReasoners));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$TestReasoners;

    public TestRDFSReasoners(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        try {
            TestRDFSReasoners.constructRDFWGtests(testSuite, RDFSReasonerFactory.theInstance(), null);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest.rdf", RDFSReasonerFactory.theInstance(), null);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest-nodirect-noresource.rdf", RDFSFBRuleReasonerFactory.theInstance(), null);
            Resource resource = new ModelMem().createResource().addProperty(ReasonerVocabulary.PROPenableCMPScan, true);
            TestRDFSReasoners.constructRDFWGtests(testSuite, RDFSRuleReasonerFactory.theInstance(), null);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest-standard.rdf", RDFSRuleReasonerFactory.theInstance(), resource);
            testSuite.addTest((Test)new TestRDFSMisc(RDFSRuleReasonerFactory.theInstance(), null));
            Resource resource2 = new ModelMem().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, ReasonerVocabulary.RDFS_FULL);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest.rdf", RDFSRuleReasonerFactory.theInstance(), resource2);
            Resource resource3 = new ModelMem().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, ReasonerVocabulary.RDFS_SIMPLE);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest-simple.rdf", RDFSRuleReasonerFactory.theInstance(), resource3);
        }
        catch (IOException iOException) {
            logger.error((Object)"Failed to construct RDFS test harness", (Throwable)iOException);
        }
        return testSuite;
    }

    private static void constructSingleQuerytests(TestSuite testSuite, String string, String string2, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester(string);
        testSuite.addTest((Test)new TestReasonerFromManifest(reasonerTester, string2, reasonerFactory, resource));
    }

    private static void constructQuerytests(TestSuite testSuite, String string, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester(string);
        Iterator iterator = reasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            testSuite.addTest((Test)new TestReasonerFromManifest(reasonerTester, string2, reasonerFactory, resource));
        }
    }

    private static void constructRDFWGtests(TestSuite testSuite, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        WGReasonerTester wGReasonerTester = new WGReasonerTester("Manifest.rdf");
        Iterator iterator = wGReasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            testSuite.addTest((Test)new TestReasonerWG(wGReasonerTester, string, reasonerFactory, resource));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestRDFSMisc
    extends TestCase {
        ReasonerFactory reasonerFactory;
        Resource config;

        TestRDFSMisc(ReasonerFactory reasonerFactory, Resource resource) {
            super("TestRDFSMisc");
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            Object object;
            ReasonerTester reasonerTester = new ReasonerTester("rdfs/manifest.rdf");
            Resource resource = new ModelMem().createResource();
            if (this.config != null) {
                object = this.config.listProperties();
                while (object.hasNext()) {
                    Statement statement = object.nextStatement();
                    resource.addProperty(statement.getPredicate(), statement.getObject());
                }
            }
            resource.addProperty(ReasonerVocabulary.PROPenableCMPScan, "false");
            TestRDFSMisc.assertTrue((String)"scanproperties off", (!reasonerTester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test17", this.reasonerFactory, null, resource) ? 1 : 0) != 0);
            object = this.reasonerFactory.create(null);
            TestRDFSMisc.assertTrue((boolean)object.supportsProperty(RDFS.subClassOf));
            TestRDFSMisc.assertTrue((boolean)object.supportsProperty(RDFS.domain));
            TestRDFSMisc.assertTrue((boolean)object.supportsProperty(RDFS.range));
            TestRDFSMisc.assertTrue((!this.doTestRDFSDTRange("dttest1.nt", this.reasonerFactory) ? 1 : 0) != 0);
            TestRDFSMisc.assertTrue((!this.doTestRDFSDTRange("dttest2.nt", this.reasonerFactory) ? 1 : 0) != 0);
            TestRDFSMisc.assertTrue((boolean)this.doTestRDFSDTRange("dttest3.nt", this.reasonerFactory));
        }

        private boolean doTestRDFSDTRange(String string, ReasonerFactory reasonerFactory) throws IOException {
            Model model = WGReasonerTester.loadFile("../reasoners/rdfs/" + string);
            InfGraph infGraph = reasonerFactory.create(null).bind(model.getGraph());
            ValidityReport validityReport = infGraph.validate();
            if (!validityReport.isValid()) {
                logger.debug((Object)"Validation error report:");
                Iterator iterator = validityReport.getReports();
                while (iterator.hasNext()) {
                    logger.debug((Object)iterator.next().toString());
                }
            }
            return validityReport.isValid();
        }
    }

    static class TestReasonerWG
    extends TestCase {
        WGReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerWG(WGReasonerTester wGReasonerTester, String string, ReasonerFactory reasonerFactory, Resource resource) {
            super(string);
            this.tester = wGReasonerTester;
            this.test = string;
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }

    static class TestReasonerFromManifest
    extends TestCase {
        ReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerFromManifest(ReasonerTester reasonerTester, String string, ReasonerFactory reasonerFactory, Resource resource) {
            super(string);
            this.tester = reasonerTester;
            this.test = string;
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }
}

