/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLWGTester;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTrialOWLRules
extends TestCase {
    protected String manifest;
    protected static boolean enableTracing = false;
    protected static boolean printStats = true;
    protected static Resource configuration;

    public TestTrialOWLRules(String string) {
        super(string);
        this.manifest = string;
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestTrialOWLRules("SymmetricProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("someValuesFrom/Manifest001.rdf"));
        return testSuite;
    }

    protected void runTest() throws IOException {
        OWLWGTester oWLWGTester = new OWLWGTester(GenericRuleReasonerFactory.theInstance(), this, configuration);
        oWLWGTester.runTests(this.manifest, enableTracing, printStats);
    }

    public static void main(String[] stringArray) {
        Model model = ModelLoader.loadModel("file:testing/wg/someValuesFrom/premises001.rdf");
        Reasoner reasoner = GenericRuleReasonerFactory.theInstance().create(configuration);
        InfModel infModel = ModelFactory.createInfModel(reasoner, model);
        System.out.println("Premises = ");
        Object object = model.listStatements();
        while (object.hasNext()) {
            System.out.println(" - " + object.next());
        }
        object = infModel.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#i");
        Property property = infModel.getProperty("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#p");
        Resource resource = infModel.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#c");
        Resource resource2 = infModel.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#r");
        Resource resource3 = (Resource)object.getProperty(property).getObject();
        System.out.println("Value of i.p = " + resource3);
        System.out.println("Types of v are: ");
        StmtIterator stmtIterator = infModel.listStatements(resource3, RDF.type, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            System.out.println(" - " + stmtIterator.next());
        }
    }

    static {
        Model model = ModelFactory.createDefaultModel();
        configuration = model.createResource("http://www.hpl.hp.com/semweb/2003/GenericRuleReasoner");
        configuration.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        configuration.addProperty(ReasonerVocabulary.PROPruleSet, "etc/owl-fb-test.rules");
        configuration.addProperty(ReasonerVocabulary.PROPenableOWLTranslation, true);
    }
}

