/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestFBRules
extends TestCase {
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules = TestFBRules.class$("com.hp.hpl.jena.reasoner.rulesys.test.TestFBRules")) : class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules));
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node n1 = Node.createURI("n1");
    Node n2 = Node.createURI("n2");
    Node n3 = Node.createURI("n3");
    Node n4 = Node.createURI("n4");
    Node res = Node.createURI("res");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node t = Node.createURI("t");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node C1 = Node.createURI("C1");
    Node C2 = Node.createURI("C2");
    Node C3 = Node.createURI("C3");
    Node sP = RDFS.subPropertyOf.getNode();
    Node sC = RDFS.subClassOf.getNode();
    Node ty = RDF.type.getNode();
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules;

    public TestFBRules(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules = TestFBRules.class$("com.hp.hpl.jena.reasoner.rulesys.test.TestFBRules")) : class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules);
    }

    public void testParser() {
        String string = "(?a rdf:type ?t) -> (?t rdf:type rdfs:Class).";
        String string2 = "(?t rdf:type rdfs:Class) <- (?a rdf:type ?t).";
        TestFBRules.assertTrue((!Rule.parseRule(string).isBackward() ? 1 : 0) != 0);
        TestFBRules.assertTrue((boolean)Rule.parseRule(string2).isBackward());
    }

    public void testRuleMatcher() {
        String string = "[r1: (?a p ?b), (?b q ?c) -> (?a, q, ?c)][r2: (?a p ?b), (?b p ?c) -> (?a, p, ?c)][r3: (?a p ?a), (n1 p ?c), (n1, p, ?a) -> (?a, p, ?c)][r4: (n4 ?p ?a) -> (n4, ?a, ?p)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new FBRuleReasoner(list).bind(new GraphMem());
        infGraph.add(new Triple(this.n1, this.p, this.n2));
        infGraph.add(new Triple(this.n2, this.p, this.n3));
        infGraph.add(new Triple(this.n2, this.q, this.n3));
        infGraph.add(new Triple(this.n4, this.p, this.n4));
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4), new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3), new Triple(this.n4, this.n4, this.p)});
    }

    public void testEmbeddedFunctors() {
        String string = "(?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D) -> (?C rb:restriction all(?P, ?D)).(?C rb:restriction all(eg:p, eg:D)) -> (?C rb:restriction 'allOK').[ -> (eg:foo eg:prop functor(eg:bar, '1')) ][ (?x eg:prop functor(eg:bar, ?v)) -> (?x eg:propbar ?v) ][ (?x eg:prop functor(?v, *)) -> (?x eg:propfunc ?v) ]";
        List list = Rule.parseRules(string);
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("urn:x-hp:eg/R1");
        Resource resource2 = model.createResource("urn:x-hp:eg/D");
        Property property = model.createProperty("urn:x-hp:eg/", "p");
        Property property2 = model.createProperty("urn:x-hp:eg/", "prop");
        Property property3 = model.createProperty("urn:x-hp:eg/", "propbar");
        Property property4 = model.createProperty("urn:x-hp:eg/", "propfunc");
        Property property5 = model.createProperty("urn:x-hp-jena:rubrik/", "restriction");
        resource.addProperty(RDF.type, OWL.Restriction).addProperty(OWL.onProperty, property).addProperty(OWL.allValuesFrom, resource2);
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(model.getGraph());
        Model model2 = ModelFactory.createModelForGraph(infGraph);
        Resource resource3 = model2.createResource("urn:x-hp:eg/foo");
        Resource resource4 = model2.createResource("urn:x-hp:eg/bar");
        RDFNode rDFNode = model2.getResource(resource.getURI()).getProperty(property5).getObject();
        TestFBRules.assertNotNull((Object)rDFNode);
        TestFBRules.assertEquals((String)((Object)rDFNode).toString(), (String)"allOK");
        Literal literal = (Literal)resource3.getProperty(property3).getObject();
        TestFBRules.assertEquals((Object)new Integer(1), (Object)literal.getValue());
    }

    public void testBuiltins() {
        String string = "[r1: (n1 p ?x), addOne(?x, ?y) -> (n1 q ?y)][r2: (n1 p ?x), lessThan(?x, '3') -> (n2 q ?x)][axiom1: -> (n1 p '1')][axiom2: -> (n1 p '4')]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new FBRuleReasoner(list).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, this.q, null), new Triple[]{new Triple(this.n1, this.q, Util.makeIntNode(2)), new Triple(this.n1, this.q, Util.makeIntNode(5))});
        TestUtil.assertIteratorValues(this, infGraph.find(this.n2, this.q, null), new Triple[]{new Triple(this.n2, this.q, Util.makeIntNode(1))});
    }

    public void testSchemaBinding() {
        String string = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][testBRule4: (n3 p ?a) <- (n1, p, ?a)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.n1, this.p, this.n3));
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.n1, this.q, this.n4));
        graphMem2.add(new Triple(this.n1, this.q, this.n3));
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        Reasoner reasoner = fBRuleReasoner.bindSchema(graphMem);
        InfGraph infGraph = reasoner.bind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n3, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
    }

    public void testRemoveBuiltin() {
        String string = "[rule1: (?x p ?y), (?x q ?y) -> remove('0')]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new FBRuleReasoner(list).bind(new GraphMem());
        infGraph.add(new Triple(this.n1, this.p, Util.makeIntNode(1)));
        infGraph.add(new Triple(this.n1, this.p, Util.makeIntNode(2)));
        infGraph.add(new Triple(this.n1, this.q, Util.makeIntNode(2)));
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode(1)), new Triple(this.n1, this.q, Util.makeIntNode(2))});
    }

    public void testRebind() {
        String string = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infGraph = new FBRuleReasoner(list).bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n1, this.q, this.n2)});
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.n1, this.p, this.n3));
        infGraph.rebind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3)});
    }

    public void testBackchain1() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.p, this.sP, this.q));
        graphMem.add(new Triple(this.q, this.sP, this.r));
        graphMem.add(new Triple(this.C1, this.sC, this.C2));
        graphMem.add(new Triple(this.C2, this.sC, this.C3));
        graphMem.add(new Triple(this.a, this.ty, this.C1));
        List list = Rule.parseRules("[rdfs8:  (?a rdfs:subClassOf ?c) <- (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c)][rdfs9:  (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y), (?a rdf:type ?x)][-> (rdf:type rdfs:range rdfs:Class)][rdfs3:  (?y rdf:type ?c) <- (?x ?p ?y), (?p rdfs:range ?c)][rdfs7:  (?a rdfs:subClassOf ?a) <- (?a rdf:type rdfs:Class)]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, infGraph.find(this.C1, this.sC, this.a), new Object[0]);
    }

    public void testBackchain2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.c, this.q, this.d));
        List list = Rule.parseRules("[r1: (c r ?x) <- (?x p f(?x b))][r2: (?y p f(a ?y)) <- (c q ?y)]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[0]);
        graphMem.add(new Triple(this.c, this.q, this.a));
        list = Rule.parseRules("[r1: (c r ?x) <- (?x p f(?x a))][r2: (?y p f(a ?y)) <- (c q ?y)]");
        fBRuleReasoner = new FBRuleReasoner(list);
        infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
        graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.q, this.a));
        graphMem.add(new Triple(this.a, this.q, this.b));
        graphMem.add(new Triple(this.a, this.q, this.c));
        graphMem.add(new Triple(this.b, this.q, this.d));
        graphMem.add(new Triple(this.b, this.q, this.b));
        list = Rule.parseRules("[r1: (c r ?x) <- (?x p ?x)][r2: (?x p ?y) <- (a q ?x), (b q ?y)]");
        fBRuleReasoner = new FBRuleReasoner(list);
        infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.b)});
        list = Rule.parseRules("[r1: (c r ?x) <- (?x p ?x)][r2: (a p ?x) <- (a q ?x)]");
        fBRuleReasoner = new FBRuleReasoner(list);
        infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
    }

    public void testBackchain3() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, this.r));
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.r, this.sC, this.C1));
        graphMem.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        graphMem.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        graphMem.add(new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c));
        List list = Rule.parseRules("[rdfs9:   (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y) (?a rdf:type ?x)][restriction2: (?C owl:equivalentClass all(?P, ?D)) <- (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D)][rs2: (?X rdf:type all(?P,?C)) <- (?D owl:equivalentClass all(?P,?C)), (?X rdf:type ?D)][rp4: (?Y rdf:type ?C) <- (?X rdf:type all(?P, ?C)), (?X ?P ?Y)]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, this.c), new Object[]{new Triple(this.b, this.ty, this.c)});
    }

    public void testHybrid1() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.p, this.ty, this.s));
        List list = Rule.parseRules("[r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
    }

    public void testHybrid2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.p, this.ty, this.s));
        List list = Rule.parseRules("[a1: -> (a rdf:type t)][r0: (?x r ?y) -> (?x p ?y)][r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]][r2: (?p rdf:type s) -> [r2b: (?x ?p ?x) <- (?x rdf:type t)]]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        FBRuleInfGraph fBRuleInfGraph = (FBRuleInfGraph)fBRuleReasoner.bind(graphMem);
        fBRuleInfGraph.setDerivationLogging(true);
        fBRuleInfGraph.prepare();
        TestFBRules.assertTrue((String)"Forward rule count", (fBRuleInfGraph.getNRulesFired() == 3L ? 1 : 0) != 0);
        TestUtil.assertIteratorValues(this, fBRuleInfGraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        TestFBRules.assertTrue((String)"Backward rule count", (fBRuleInfGraph.getNRulesFired() == 8L ? 1 : 0) != 0);
        Iterator iterator = fBRuleInfGraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestFBRules.assertTrue((boolean)iterator.hasNext());
        RuleDerivation ruleDerivation = (RuleDerivation)iterator.next();
        TestFBRules.assertTrue((boolean)ruleDerivation.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, ruleDerivation.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestFBRules.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    public void testHybridRDFS() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.p, RDFS.range.asNode(), this.C1));
        List list = Rule.parseRules("[rdfs2:  (?p rdfs:domain ?c) -> [(?x rdf:type ?c) <- (?x ?p ?y)] ][rdfs3:  (?p rdfs:range ?c)  -> [(?y rdf:type ?c) <- (?x ?p ?y)] ][rdfs5a: (?a rdfs:subPropertyOf ?b), (?b rdfs:subPropertyOf ?c) -> (?a rdfs:subPropertyOf ?c)][rdfs5b: (?a rdf:type rdf:Property) -> (?a rdfs:subPropertyOf ?a)][rdfs6:  (?p rdfs:subPropertyOf ?q) -> [ (?a ?q ?b) <- (?a ?p ?b)] ][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)][rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs9:  (?x rdfs:subClassOf ?y) -> [ (?a rdf:type ?y) <- (?a rdf:type ?x)] ]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, null), new Object[]{new Triple(this.b, this.ty, this.C1)});
    }

    public void testHybridRDFS2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.p, this.sP, this.r));
        graphMem.add(new Triple(this.r, RDFS.range.asNode(), this.C1));
        List list = Rule.parseRules("[rdfs3:  (?p rdfs:range ?c)  -> [(?y rdf:type ?c) <- (?x ?p ?y)] ][rdfs6:  (?p rdfs:subPropertyOf ?q) -> [ (?a ?q ?b) <- (?a ?p ?b)] ]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, this.C1), new Object[]{new Triple(this.b, this.ty, this.C1)});
    }

    public void testMakeInstance() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, this.C1));
        List list = Rule.parseRules("[r1:  (?x p ?t) <- (?x rdf:type C1), makeInstance(?x, p, C2, ?t)][r2:  (?t rdf:type C2) <- (?x rdf:type C1), makeInstance(?x, p, C2, ?t)]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        Node node = this.getValue(infGraph, this.a, this.p);
        TestFBRules.assertNotNull((Object)node);
        Node node2 = this.getValue(infGraph, this.a, this.p);
        TestFBRules.assertEquals((Object)node, (Object)node2);
        Node node3 = this.getValue(infGraph, node, RDF.type.asNode());
        TestFBRules.assertEquals((Object)node3, (Object)this.C2);
    }

    public void testMakeInstances() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, this.C1));
        List list = Rule.parseRules("[r1:  (?x p ?t) <- (?x rdf:type C1), makeInstance(?x, p, ?t)]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        Node node = this.getValue(infGraph, this.a, this.p);
        TestFBRules.assertNotNull((Object)node);
        Node node2 = this.getValue(infGraph, this.a, this.p);
        TestFBRules.assertEquals((Object)node, (Object)node2);
    }

    public void testMakeInstanceBug() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, this.r));
        graphMem.add(new Triple(this.r, this.sC, Functor.makeFunctorNode("some", new Node[]{this.p, this.C1})));
        List list = Rule.parseRules("[some1: (?C rdfs:subClassOf some(?P, ?D)) ->[some1b: (?X ?P ?T) <- (?X rdf:type ?C), unbound(?T), noValue(?X, ?P), makeInstance(?X, ?P, ?D, ?T) ][some1b2: (?T rdf:type ?D) <- (?X rdf:type ?C), bound(?T), makeInstance(?X, ?P, ?D, ?T) ]]");
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        InfGraph infGraph = fBRuleReasoner.bind(graphMem);
        Node node = this.getValue(infGraph, this.a, this.p);
        TestFBRules.assertNotNull((Object)node);
        Node node2 = this.getValue(infGraph, node, this.ty);
        TestFBRules.assertEquals((Object)node2, (Object)this.C1);
    }

    private Node getValue(Graph graph, Node node, Node node2) {
        ExtendedIterator extendedIterator = graph.find(node, node2, null);
        TestFBRules.assertTrue((boolean)extendedIterator.hasNext());
        Node node3 = ((Triple)extendedIterator.next()).getObject();
        if (extendedIterator.hasNext()) {
            TestFBRules.assertTrue((String)"multiple values not expected", (boolean)false);
            extendedIterator.close();
        }
        return node3;
    }

    public void testDuplicatesEC4() throws IOException {
        Object e;
        Model model = ModelLoader.loadModel("file:testing/wg/equivalentClass/premises004.rdf");
        Graph graph = model.getGraph();
        OWLFBRuleReasoner oWLFBRuleReasoner = new OWLFBRuleReasoner(OWLFBRuleReasonerFactory.theInstance());
        InfGraph infGraph = oWLFBRuleReasoner.bind(graph);
        Node node = Node.createURI("urn:x-hp-jena:rubrik/prototype");
        int n = 0;
        ExtendedIterator extendedIterator = infGraph.find(null, node, null);
        while (extendedIterator.hasNext()) {
            e = extendedIterator.next();
            ++n;
        }
        TestFBRules.assertTrue((n == 7 ? 1 : 0) != 0);
        infGraph = oWLFBRuleReasoner.bindSchema(graph).bind(new GraphMem());
        n = 0;
        extendedIterator = infGraph.find(null, node, null);
        while (extendedIterator.hasNext()) {
            e = extendedIterator.next();
            ++n;
        }
        TestFBRules.assertTrue((n == 7 ? 1 : 0) != 0);
    }

    public void temp() {
        GraphMem graphMem = new GraphMem();
        GraphMem graphMem2 = new GraphMem();
        OWLFBRuleReasoner oWLFBRuleReasoner = new OWLFBRuleReasoner(OWLFBRuleReasonerFactory.theInstance());
        FBRuleInfGraph fBRuleInfGraph = (FBRuleInfGraph)oWLFBRuleReasoner.bind(graphMem);
        FBRuleInfGraph fBRuleInfGraph2 = (FBRuleInfGraph)oWLFBRuleReasoner.bind(graphMem2);
        long l = System.currentTimeMillis();
        fBRuleInfGraph.prepare();
        long l2 = System.currentTimeMillis();
        System.out.println("Prepare on empty graph = " + (l2 - l) + "ms");
        l = System.currentTimeMillis();
        fBRuleInfGraph2.prepare();
        l2 = System.currentTimeMillis();
        System.out.println("Prepare on empty graph = " + (l2 - l) + "ms");
    }

    public void listGraph(Graph graph) {
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            logger.info((Object)PrintUtil.print(triple));
        }
        logger.info((Object)"  --------  ");
    }

    public void listFBGraph(String string, FBRuleInfGraph fBRuleInfGraph) {
        logger.info((Object)string);
        logger.info((Object)"Raw graph data");
        this.listGraph(fBRuleInfGraph.getRawGraph());
        logger.info((Object)"Static deductions");
        this.listGraph(fBRuleInfGraph.getDeductionsGraph());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

