/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.OneToManyMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuleStore {
    protected OneToManyMap goalMap = new OneToManyMap();
    protected List allRules;
    protected Set ruleIndex = new HashSet();

    public RuleStore() {
        this.allRules = new ArrayList();
    }

    public RuleStore(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addRule((Rule)iterator.next());
        }
        this.allRules = list;
    }

    public void addRule(Rule rule) {
        this.addRemoveRule(rule, true);
    }

    public void deleteRule(Rule rule) {
        this.addRemoveRule(rule, false);
    }

    private void addRemoveRule(Rule rule, boolean bl) {
        if (rule.headLength() != 1) {
            for (int i = 0; i < rule.headLength(); ++i) {
                Rule rule2 = new Rule(rule.getName(), new ClauseEntry[]{rule.getHeadElement(i)}, rule.getBody());
                rule2.setNumVars(rule.getNumVars());
                this.doAddRemoveRule(rule2, bl);
            }
        } else {
            this.doAddRemoveRule(rule, bl);
        }
    }

    private void doAddRemoveRule(Rule rule, boolean bl) {
        ClauseEntry clauseEntry;
        if (bl && this.ruleIndex.contains(rule)) {
            return;
        }
        if (bl) {
            this.ruleIndex.add(rule);
        } else {
            this.ruleIndex.remove(rule);
        }
        if (this.allRules != null) {
            this.allRules.add(rule);
        }
        if ((clauseEntry = rule.getHeadElement(0)) instanceof TriplePattern) {
            TriplePattern triplePattern = (TriplePattern)clauseEntry;
            Node node = triplePattern.getPredicate();
            if (node.isVariable()) {
                if (bl) {
                    this.goalMap.put(Node.ANY, rule);
                } else {
                    this.goalMap.remove(Node.ANY, rule);
                }
            } else if (bl) {
                this.goalMap.put(node, rule);
            } else {
                this.goalMap.remove(node, rule);
            }
        }
    }

    public List rulesFor(TriplePattern triplePattern) {
        ArrayList arrayList = new ArrayList();
        if (triplePattern.getPredicate().isVariable()) {
            this.checkAll(this.goalMap.values().iterator(), triplePattern, arrayList);
        } else {
            this.checkAll(this.goalMap.getAll(triplePattern.getPredicate()), triplePattern, arrayList);
            this.checkAll(this.goalMap.getAll(Node.ANY), triplePattern, arrayList);
        }
        return arrayList;
    }

    public List getAllRules() {
        return this.allRules;
    }

    public void deleteAllRules() {
        this.allRules.clear();
        this.goalMap.clear();
        this.ruleIndex.clear();
    }

    private void checkAll(Iterator iterator, TriplePattern triplePattern, List list) {
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!((TriplePattern)rule.getHeadElement(0)).compatibleWith(triplePattern)) continue;
            list.add(rule);
        }
    }
}

