/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GoalResults {
    protected TriplePattern goal;
    protected ArrayList resultSet;
    protected HashSet resultSetIndex;
    protected boolean isComplete;
    protected boolean started = false;
    protected Set dependents = new HashSet();
    protected BRuleEngine engine;
    protected int refCount = 0;
    protected boolean isSingleton = false;
    static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalResults == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalResults = GoalResults.class$("com.hp.hpl.jena.reasoner.rulesys.impl.GoalResults")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalResults));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalResults;

    public GoalResults(TriplePattern triplePattern, BRuleEngine bRuleEngine) {
        this.goal = triplePattern;
        this.resultSet = new ArrayList();
        this.resultSetIndex = new HashSet();
        this.isComplete = false;
        this.engine = bRuleEngine;
        this.isSingleton = !triplePattern.getSubject().isVariable() && !triplePattern.getPredicate().isVariable() && !triplePattern.getObject().isVariable();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public int numResults() {
        if (!this.started) {
            this.start();
        }
        return this.resultSet.size();
    }

    public Triple getResult(int n) {
        return (Triple)this.resultSet.get(n);
    }

    public void addDependent(RuleState ruleState) {
        if (!this.isComplete) {
            this.dependents.add(ruleState);
        }
    }

    public void flushDependents() {
        Iterator iterator = this.dependents.iterator();
        while (iterator.hasNext()) {
            RuleState ruleState = (RuleState)iterator.next();
            this.engine.prependToAgenda(ruleState);
        }
    }

    public BRuleEngine getEngine() {
        return this.engine;
    }

    public void setComplete() {
        if (!this.isComplete) {
            if (this.engine.isTraceOn()) {
                logger.debug((Object)("Completed " + this));
            }
            this.isComplete = true;
            this.resultSetIndex = null;
            this.flushDependents();
            this.dependents.clear();
        }
    }

    public void setAllComplete() {
        this.isComplete = true;
        this.dependents.clear();
    }

    public void start() {
        List list = this.engine.rulesFor(this.goal);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            RuleState ruleState = RuleState.createInitialState(rule, this);
            if (ruleState == null) continue;
            this.engine.appendToAgenda(ruleState);
        }
        if (this.refCount <= 0) {
            this.setComplete();
        }
        this.started = true;
    }

    public boolean addResult(Triple triple) {
        if (!this.isComplete && !this.resultSetIndex.contains(triple)) {
            this.resultSet.add(triple);
            this.resultSetIndex.add(triple);
            if (this.isSingleton) {
                this.setComplete();
            } else {
                this.flushDependents();
            }
            return true;
        }
        return false;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
        if (this.refCount <= 0) {
            this.setComplete();
        }
    }

    public String toString() {
        return "GoalResult for: " + this.goal;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

