/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.PrintUtil;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RuleDerivation
implements Derivation {
    protected Rule rule;
    protected Triple conclusion;
    protected List matches;
    protected InfGraph infGraph;

    public RuleDerivation(Rule rule, Triple triple, List list, InfGraph infGraph) {
        this.rule = rule;
        this.conclusion = triple;
        this.matches = list;
        this.infGraph = infGraph;
    }

    public String toString() {
        return "Rule " + this.rule.toShortString();
    }

    public void printTrace(PrintWriter printWriter, boolean bl) {
        this.printTrace(printWriter, bl, 0, new HashSet());
    }

    protected void printTrace(PrintWriter printWriter, boolean bl, int n, HashSet hashSet) {
        PrintUtil.printIndent(printWriter, n);
        printWriter.print(this.toString());
        if (bl) {
            printWriter.print(" concluded " + PrintUtil.print(this.conclusion));
        }
        printWriter.println(" <-");
        int n2 = n + 4;
        Iterator iterator = this.matches.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            Iterator iterator2 = this.infGraph.getDerivation(triple);
            if (iterator2 == null || !iterator2.hasNext()) {
                PrintUtil.printIndent(printWriter, n2);
                printWriter.println("Fact " + PrintUtil.print(triple));
                continue;
            }
            RuleDerivation ruleDerivation = (RuleDerivation)iterator2.next();
            if (hashSet.contains(ruleDerivation)) {
                PrintUtil.printIndent(printWriter, n2);
                printWriter.println("Known " + PrintUtil.print(triple) + " - already shown");
                continue;
            }
            hashSet.add(ruleDerivation);
            ruleDerivation.printTrace(printWriter, bl, n2, hashSet);
        }
    }

    public Triple getConclusion() {
        return this.conclusion;
    }

    public List getMatches() {
        return this.matches;
    }

    public Rule getRule() {
        return this.rule;
    }
}

