/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.RDFSCMPPreprocessHook;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RDFSRuleReasoner
extends GenericRuleReasoner {
    public static final String DEFAULT_RULES = "default";
    public static final String FULL_RULES = "full";
    public static final String SIMPLE_RULES = "simple";
    protected static final String RULE_FILE = "etc/rdfs-fb-tgc-noresource.rules";
    protected static final String FULL_RULE_FILE = "etc/rdfs-fb-tgc.rules";
    protected static final String SIMPLE_RULE_FILE = "etc/rdfs-fb-tgc-simple.rules";
    protected static HashMap ruleSets = new HashMap();
    protected static HashMap ruleFiles;
    protected static RulePreprocessHook cmpProcessor;

    public RDFSRuleReasoner(ReasonerFactory reasonerFactory) {
        super(RDFSRuleReasoner.loadRules(DEFAULT_RULES), reasonerFactory);
        this.setMode(HYBRID);
        this.setTransitiveClosureCaching(true);
    }

    public RDFSRuleReasoner(ReasonerFactory reasonerFactory, Resource resource) {
        this(reasonerFactory);
        if (resource != null) {
            StmtIterator stmtIterator = resource.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                this.doSetParameter(statement.getPredicate().getURI(), ((Object)statement.getObject()).toString());
            }
        }
    }

    protected boolean doSetParameter(String string, Object object) {
        if (string.equals(ReasonerVocabulary.PROPenableCMPScan.getURI())) {
            boolean bl = Util.convertBooleanPredicateArg(string, object);
            if (bl) {
                this.addPreprocessingHook(cmpProcessor);
            } else {
                this.removePreprocessingHook(cmpProcessor);
            }
            return true;
        }
        if (string.equals(ReasonerVocabulary.PROPsetRDFSLevel.getURI())) {
            String string2 = ((String)object).toLowerCase();
            this.setRules(RDFSRuleReasoner.loadRules(string2));
            if (string2.equals(FULL_RULES)) {
                this.addPreprocessingHook(cmpProcessor);
            } else {
                this.removePreprocessingHook(cmpProcessor);
            }
            return true;
        }
        return super.doSetParameter(string, object);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        RDFSRuleInfGraph rDFSRuleInfGraph;
        Graph graph2 = this.schemaGraph == null ? this.getPreload() : this.schemaGraph;
        RDFSRuleInfGraph rDFSRuleInfGraph2 = null;
        List list = ((FBRuleInfGraph)graph2).getRules();
        rDFSRuleInfGraph2 = rDFSRuleInfGraph = new RDFSRuleInfGraph(this, list, graph2);
        if (this.enableTGCCaching) {
            rDFSRuleInfGraph.setUseTGCCache();
        }
        rDFSRuleInfGraph.setTraceOn(this.traceOn);
        if (this.preprocessorHooks != null) {
            Iterator iterator = this.preprocessorHooks.iterator();
            while (iterator.hasNext()) {
                rDFSRuleInfGraph.addPreprocessingHook((RulePreprocessHook)iterator.next());
            }
        }
        rDFSRuleInfGraph2.setDerivationLogging(this.recordDerivations);
        rDFSRuleInfGraph2.rebind(graph);
        return rDFSRuleInfGraph2;
    }

    public static List loadRules(String string) {
        List list = (List)ruleSets.get(string);
        if (list == null) {
            try {
                String string2 = (String)ruleFiles.get(string);
                if (string2 == null) {
                    throw new ReasonerException("Illegal RDFS conformance level: " + string);
                }
                list = Rule.parseRules(Util.loadResourceFile(string2));
                ruleSets.put(string, list);
            }
            catch (IOException iOException) {
                throw new ReasonerException("Can't load rules file: etc/rdfs-fb-tgc-noresource.rules", iOException);
            }
        }
        return list;
    }

    static {
        cmpProcessor = new RDFSCMPPreprocessHook();
        ruleFiles = new HashMap();
        ruleFiles.put(DEFAULT_RULES, RULE_FILE);
        ruleFiles.put(FULL_RULES, FULL_RULE_FILE);
        ruleFiles.put(SIMPLE_RULES, SIMPLE_RULE_FILE);
    }
}

