/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestModelEvents
extends ModelTestBase {
    protected Model model;
    protected SimpleListener SL;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestModelEvents;

    public TestModelEvents(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestModelEvents == null ? (class$com$hp$hpl$jena$rdf$model$test$TestModelEvents = TestModelEvents.class$("com.hp.hpl.jena.rdf.model.test.TestModelEvents")) : class$com$hp$hpl$jena$rdf$model$test$TestModelEvents);
    }

    public void setUp() {
        this.model = ModelFactory.createDefaultModel();
        this.SL = new SimpleListener();
    }

    public void testRegistrationCompiles() {
        TestModelEvents.assertSame((Object)this.model, (Object)this.model.register(new SimpleListener()));
    }

    public void testUnregistrationCompiles() {
        this.model.unregister(new SimpleListener());
    }

    public void testAddSingleStatements() {
        Statement statement = TestModelEvents.statement(this.model, "S P O");
        Statement statement2 = TestModelEvents.statement(this.model, "A B C");
        TestModelEvents.assertFalse((boolean)this.SL.has(new Object[]{"add", statement}));
        this.model.register(this.SL);
        this.model.add(statement);
        this.SL.assertHas(new Object[]{"add", statement});
        this.model.add(statement2);
        this.SL.assertHas(new Object[]{"add", statement, "add", statement2});
        this.model.add(statement);
        this.SL.assertHas(new Object[]{"add", statement, "add", statement2, "add", statement});
    }

    public void testTwoListeners() {
        Statement statement = TestModelEvents.statement(this.model, "S P O");
        SimpleListener simpleListener = new SimpleListener();
        SimpleListener simpleListener2 = new SimpleListener();
        this.model.register(simpleListener).register(simpleListener2);
        this.model.add(statement);
        simpleListener2.assertHas(new Object[]{"add", statement});
        simpleListener.assertHas(new Object[]{"add", statement});
    }

    public void testUnregisterWorks() {
        this.model.register(this.SL);
        this.model.unregister(this.SL);
        this.model.add(TestModelEvents.statement(this.model, "X R Y"));
        this.SL.assertHas(new Object[0]);
    }

    public void testRemoveSingleStatements() {
        Statement statement = TestModelEvents.statement(this.model, "D E F");
        this.model.register(this.SL);
        this.model.add(statement);
        this.model.remove(statement);
        this.SL.assertHas(new Object[]{"add", statement, "remove", statement});
    }

    public void testAddInPieces() {
        this.model.register(this.SL);
        this.model.add(TestModelEvents.resource(this.model, "S"), TestModelEvents.property(this.model, "P"), TestModelEvents.resource(this.model, "O"));
        this.SL.assertHas(new Object[]{"add", TestModelEvents.statement(this.model, "S P O")});
    }

    public void testAddStatementArray() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "a P b; c Q d");
        this.model.add(statementArray);
        this.SL.assertHas(new Object[]{"add[]", Arrays.asList(statementArray)});
    }

    public void testDeleteStatementArray() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "a P b; c Q d");
        this.model.remove(statementArray);
        this.SL.assertHas(new Object[]{"remove[]", Arrays.asList(statementArray)});
    }

    public void testAddStatementList() {
        this.model.register(this.SL);
        List<Statement> list = Arrays.asList(TestModelEvents.statements(this.model, "b I g; m U g"));
        this.model.add(list);
        this.SL.assertHas(new Object[]{"addList", list});
    }

    public void testDeleteStatementList() {
        this.model.register(this.SL);
        List<Statement> list = Arrays.asList(TestModelEvents.statements(this.model, "b I g; m U g"));
        this.model.remove(list);
        this.SL.assertHas(new Object[]{"removeList", list});
    }

    public void testAddStatementIterator() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "x R y; a P b; x R y");
        StmtIterator stmtIterator = this.asIterator(statementArray);
        this.model.add(stmtIterator);
        this.SL.assertHas(new Object[]{"addIterator", Arrays.asList(statementArray)});
    }

    public void testDeleteStatementIterator() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "x R y; a P b; x R y");
        StmtIterator stmtIterator = this.asIterator(statementArray);
        this.model.remove(stmtIterator);
        this.SL.assertHas(new Object[]{"removeIterator", Arrays.asList(statementArray)});
    }

    protected StmtIterator asIterator(Statement[] statementArray) {
        return new StmtIteratorImpl(Arrays.asList(statementArray).iterator());
    }

    public void testAddModel() {
        this.model.register(this.SL);
        Model model = TestModelEvents.modelWithStatements("NT beats S; S beats H; H beats D");
        this.model.add(model);
        this.SL.assertHas(new Object[]{"addModel", model});
    }

    public void testDeleteModel() {
        this.model.register(this.SL);
        Model model = TestModelEvents.modelWithStatements("NT beats S; S beats H; H beats D");
        this.model.remove(model);
        this.SL.assertHas(new Object[]{"removeModel", model});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SimpleListener
    implements ModelChangedListener {
        List history = new ArrayList();

        SimpleListener() {
        }

        public void addedStatement(Statement statement) {
            this.record("add", statement);
        }

        public void addedStatements(Statement[] statementArray) {
            this.record("add[]", Arrays.asList(statementArray));
        }

        public void addedStatements(List list) {
            this.record("addList", list);
        }

        public void addedStatements(StmtIterator stmtIterator) {
            this.record("addIterator", GraphTestBase.iteratorToList(stmtIterator));
        }

        public void addedStatements(Model model) {
            this.record("addModel", model);
        }

        public void removedStatements(Statement[] statementArray) {
            this.record("remove[]", Arrays.asList(statementArray));
        }

        public void removedStatement(Statement statement) {
            this.record("remove", statement);
        }

        public void removedStatements(List list) {
            this.record("removeList", list);
        }

        public void removedStatements(StmtIterator stmtIterator) {
            this.record("removeIterator", GraphTestBase.iteratorToList(stmtIterator));
        }

        public void removedStatements(Model model) {
            this.record("removeModel", model);
        }

        protected void record(String string, Object object) {
            this.history.add(string);
            this.history.add(object);
        }

        boolean has(Object[] objectArray) {
            return ((Object)this.history).equals(Arrays.asList(objectArray));
        }

        void assertHas(Object[] objectArray) {
            if (!this.has(objectArray)) {
                Assert.fail((String)("expected " + Arrays.asList(objectArray) + " but got " + this.history));
            }
        }
    }
}

