/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestSuite;

public class TestModelBulkUpdate
extends ModelTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestModelBulkUpdate;

    public TestModelBulkUpdate(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestModelBulkUpdate == null ? (class$com$hp$hpl$jena$rdf$model$test$TestModelBulkUpdate = TestModelBulkUpdate.class$("com.hp.hpl.jena.rdf.model.test.TestModelBulkUpdate")) : class$com$hp$hpl$jena$rdf$model$test$TestModelBulkUpdate);
    }

    public void testMBU() {
        this.testMBU(ModelFactory.createDefaultModel());
    }

    public void testContains(Model model, Statement[] statementArray) {
        for (int i = 0; i < statementArray.length; ++i) {
            TestModelBulkUpdate.assertTrue((String)"it should be here", (boolean)model.contains(statementArray[i]));
        }
    }

    public void testContains(Model model, List list) {
        for (int i = 0; i < list.size(); ++i) {
            TestModelBulkUpdate.assertTrue((String)"it should be here", (boolean)model.contains((Statement)list.get(i)));
        }
    }

    public void testOmits(Model model, Statement[] statementArray) {
        for (int i = 0; i < statementArray.length; ++i) {
            TestModelBulkUpdate.assertFalse((String)"it should not be here", (boolean)model.contains(statementArray[i]));
        }
    }

    public void testOmits(Model model, List list) {
        for (int i = 0; i < list.size(); ++i) {
            TestModelBulkUpdate.assertFalse((String)"it should not be here", (boolean)model.contains((Statement)list.get(i)));
        }
    }

    public void testMBU(Model model) {
        Statement[] statementArray = TestModelBulkUpdate.statements(model, "moon orbits earth; earth orbits sun");
        List<Statement> list = Arrays.asList(TestModelBulkUpdate.statements(model, "I drink tea; you drink coffee"));
        model.add(statementArray);
        this.testContains(model, statementArray);
        model.add(list);
        this.testContains(model, list);
        this.testContains(model, statementArray);
        model.remove(statementArray);
        this.testOmits(model, statementArray);
        this.testContains(model, list);
        model.remove(list);
        this.testOmits(model, statementArray);
        this.testOmits(model, list);
    }

    public void testBulkByModel() {
        this.testBulkByModel(ModelFactory.createDefaultModel());
    }

    public void testBulkByModel(Model model) {
        TestModelBulkUpdate.assertEquals((String)"precondition: model must be empty", (long)0L, (long)model.size());
        Model model2 = TestModelBulkUpdate.modelWithStatements("clouds offer rain; trees offer shelter");
        Model model3 = TestModelBulkUpdate.modelWithStatements("x R y; y Q z; z P x");
        model.add(model2);
        this.assertIsoModels("", model2, model);
        model.add(model3);
        model.remove(model2);
        this.assertIsoModels("", model3, model);
        model.remove(model3);
        TestModelBulkUpdate.assertEquals((String)"", (long)0L, (long)model.size());
    }

    public void testBulkRemoveSelf() {
        Model model = TestModelBulkUpdate.modelWithStatements("they sing together; he sings alone");
        model.remove(model);
        TestModelBulkUpdate.assertEquals((String)"", (long)0L, (long)model.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

