/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.Command;

public abstract class AbstractTestModel
extends ModelTestBase {
    private Model model;

    public AbstractTestModel(String string) {
        super(string);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
    }

    public void tearDown() {
        this.model.close();
    }

    public void testTransactions() {
        Command command = null;
        if (this.model.supportsTransactions()) {
            this.model.executeInTransaction(command);
        }
    }

    public void testCreateResourceFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("spoo:S"));
        AbstractTestModel.assertTrue((boolean)(rDFNode instanceof Resource));
        AbstractTestModel.assertEquals((String)"spoo:S", (String)((Resource)rDFNode).getURI());
    }

    public void testCreateLiteralFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("42"));
        AbstractTestModel.assertTrue((boolean)(rDFNode instanceof Literal));
        AbstractTestModel.assertEquals((String)"42", (String)((Literal)rDFNode).getLexicalForm());
    }

    public void testCreateBlankFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("_Blank"));
        AbstractTestModel.assertTrue((boolean)(rDFNode instanceof Resource));
        AbstractTestModel.assertEquals((Object)new AnonId("_Blank"), (Object)((Resource)rDFNode).getId());
    }

    public void testIsEmpty() {
        Statement statement = AbstractTestModel.statement(this.model, "model rdf:type nonEmpty");
        Statement statement2 = AbstractTestModel.statement(this.model, "pinky rdf:type Pig");
        AbstractTestModel.assertTrue((boolean)this.model.isEmpty());
        this.model.add(statement);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.add(statement2);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.remove(statement);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.remove(statement2);
        AbstractTestModel.assertTrue((boolean)this.model.isEmpty());
    }

    public void testContainsResource() {
        AbstractTestModel.modelAdd(this.model, "x R y; _a P _b");
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "x")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "R")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "y")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "_a")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "P")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "_b")));
        AbstractTestModel.assertFalse((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "i")));
        AbstractTestModel.assertFalse((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "_j")));
    }
}

