/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.JenaSeqIndexBoundsException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelI;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.SeqNodeIteratorFactoryImpl;
import com.hp.hpl.jena.vocabulary.RDF;

public class SeqImpl
extends ContainerImpl
implements Seq {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return true;
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new SeqImpl(node, enhGraph);
        }
    };
    static NodeIteratorFactory iteratorFactory = new SeqNodeIteratorFactoryImpl();

    public SeqImpl(Model model) {
        super(model);
    }

    public SeqImpl(String string, Model model) {
        super(string, model);
    }

    public SeqImpl(Resource resource, Model model) {
        super(resource, model);
    }

    public SeqImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public Resource getResource(int n) {
        return this.getProperty(RDF.li(n)).getResource();
    }

    public Literal getLiteral(int n) {
        return this.getProperty(RDF.li(n)).getLiteral();
    }

    public RDFNode getObject(int n) {
        return this.getProperty(RDF.li(n)).getObject();
    }

    public boolean getBoolean(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getBoolean();
    }

    public byte getByte(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getByte();
    }

    public short getShort(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getShort();
    }

    public int getInt(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getInt();
    }

    public long getLong(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getLong();
    }

    public char getChar(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getChar();
    }

    public float getFloat(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getFloat();
    }

    public double getDouble(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getDouble();
    }

    public String getString(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getString();
    }

    public String getLanguage(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getLanguage();
    }

    public Object getObject(int n, ObjectF objectF) {
        return this.getProperty(RDF.li(n)).getObject(objectF);
    }

    public Resource getResource(int n, ResourceF resourceF) {
        return this.getProperty(RDF.li(n)).getResource(resourceF);
    }

    public Bag getBag(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getBag();
    }

    public Alt getAlt(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getAlt();
    }

    public Seq getSeq(int n) {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getSeq();
    }

    public Seq set(int n, RDFNode rDFNode) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(rDFNode);
        return this;
    }

    public Seq set(int n, boolean bl) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(bl);
        return this;
    }

    public Seq set(int n, long l) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(l);
        return this;
    }

    public Seq set(int n, float f) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(f);
        return this;
    }

    public Seq set(int n, double d) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(d);
        return this;
    }

    public Seq set(int n, char c) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(c);
        return this;
    }

    public Seq set(int n, String string) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(string);
        return this;
    }

    public Seq set(int n, String string, String string2) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(string, string2);
        return this;
    }

    public Seq set(int n, Object object) {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).changeObject(object);
        return this;
    }

    public Seq add(int n, boolean bl) {
        return this.add(n, String.valueOf(bl));
    }

    public Seq add(int n, long l) {
        return this.add(n, String.valueOf(l));
    }

    public Seq add(int n, char c) {
        return this.add(n, String.valueOf(c));
    }

    public Seq add(int n, float f) {
        return this.add(n, String.valueOf(f));
    }

    public Seq add(int n, double d) {
        return this.add(n, String.valueOf(d));
    }

    public Seq add(int n, Object object) {
        return this.add(n, String.valueOf(object));
    }

    public Seq add(int n, String string) {
        return this.add(n, string, "");
    }

    public Seq add(int n, String string, String string2) {
        return this.add(n, this.literal(string, string2));
    }

    public Seq add(int n, RDFNode rDFNode) {
        int n2 = this.size();
        this.checkIndex(n, n2 + 1);
        this.shiftUp(n, n2);
        this.addProperty(RDF.li(n), rDFNode);
        return this;
    }

    public NodeIterator iterator() {
        return ((ModelI)((Object)this.getModel())).listContainerMembers(this, iteratorFactory);
    }

    public Container remove(Statement statement) {
        this.getModel().remove(statement);
        this.shiftDown(statement.getPredicate().getOrdinal() + 1, this.size() + 1);
        return this;
    }

    public Seq remove(int n) {
        this.getProperty(RDF.li(n)).remove();
        this.shiftDown(n + 1, this.size() + 1);
        return this;
    }

    public Container remove(int n, RDFNode rDFNode) {
        return this.remove(this.getModel().createStatement((Resource)this, RDF.li(n), rDFNode).remove());
    }

    public int indexOf(RDFNode rDFNode) {
        return ((ModelI)((Object)this.getModel())).containerIndexOf(this, rDFNode);
    }

    public int indexOf(boolean bl) {
        return this.indexOf(String.valueOf(bl));
    }

    public int indexOf(long l) {
        return this.indexOf(String.valueOf(l));
    }

    public int indexOf(char c) {
        return this.indexOf(String.valueOf(c));
    }

    public int indexOf(float f) {
        return this.indexOf(String.valueOf(f));
    }

    public int indexOf(double d) {
        return this.indexOf(String.valueOf(d));
    }

    public int indexOf(Object object) {
        return this.indexOf(String.valueOf(object));
    }

    public int indexOf(String string) {
        return this.indexOf(string, "");
    }

    public int indexOf(String string, String string2) {
        return this.indexOf(this.literal(string, string2));
    }

    private Literal literal(String string, String string2) {
        return new LiteralImpl(Node.createLiteral(string, string2, false), this.getModel());
    }

    protected void shiftUp(int n, int n2) {
        Statement statement = null;
        for (int i = n2; i >= n; --i) {
            statement = this.getProperty(RDF.li(i));
            this.getModel().remove(statement);
            this.addProperty(RDF.li(i + 1), statement.getObject());
        }
    }

    protected void shiftDown(int n, int n2) {
        Statement statement = null;
        for (int i = n; i <= n2; ++i) {
            statement = this.getProperty(RDF.li(i));
            this.addProperty(RDF.li(i - 1), statement.getObject());
            statement.remove();
        }
    }

    protected void checkIndex(int n) {
        this.checkIndex(n, this.size());
    }

    protected void checkIndex(int n, int n2) {
        if (1 > n || n > n2) {
            throw new JenaSeqIndexBoundsException(n2, n);
        }
    }
}

