/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.JenaNoReaderForLangException;
import java.util.Properties;

public class RDFReaderFImpl
implements RDFReaderF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N3"};
    protected static final String[] DEFAULTREADERS = new String[]{"com.hp.hpl.jena.rdf.arp.JenaReader", "com.hp.hpl.jena.rdf.arp.JenaReader", "com.hp.hpl.jena.rdf.model.impl.NTripleReader", "com.hp.hpl.jena.n3.N3JenaReader"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "com.hp.hpl.jena.reader.";

    public RDFReader getReader() {
        return this.getReader(DEFAULTLANG);
    }

    public RDFReader getReader(String string) {
        String string2;
        if (string == null || string.equals("")) {
            string = LANGS[0];
        }
        if ((string2 = langToClassName.getProperty(string)) == null || string2.equals("")) {
            throw new JenaNoReaderForLangException(string);
        }
        try {
            return (RDFReader)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public String setReaderClassName(String string, String string2) {
        String string3 = langToClassName.getProperty(string);
        langToClassName.setProperty(string, string2);
        return string3;
    }

    static {
        langToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            langToClassName.setProperty(LANGS[i], Util.getProperty(PROPNAMEBASE + LANGS[i], DEFAULTREADERS[i]));
        }
    }
}

