/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.impl.GraphRDBMaker;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.impl.DAMLModelImpl;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactoryBase;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.impl.InfModelImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;

public class ModelFactory
extends ModelFactoryBase {
    private ModelFactory() {
    }

    public static Model createDefaultModel() {
        return new ModelCom(new GraphMem(Reifier.Standard));
    }

    public static Model createNonreifyingModel() {
        return new ModelCom(new GraphMem(Reifier.Minimal));
    }

    public static Model createModelForGraph(Graph graph) {
        return new ModelCom(graph);
    }

    public static ModelMaker createFileModelMaker(String string) {
        return ModelFactory.createFileModelMaker(string, Reifier.Standard);
    }

    public static ModelMaker createFileModelMaker(String string, Reifier.Style style) {
        return new ModelMakerImpl(new FileGraphMaker(string, style));
    }

    public static ModelMaker createMemModelMaker() {
        return ModelFactory.createMemModelMaker(Reifier.Standard);
    }

    public static ModelMaker createMemModelMaker(Reifier.Style style) {
        return new ModelMakerImpl(new SimpleGraphMaker(style));
    }

    public static ModelMaker createModelRDBMaker(IDBConnection iDBConnection) {
        return ModelFactory.createModelRDBMaker(iDBConnection, Reifier.Standard);
    }

    public static ModelMaker createModelRDBMaker(IDBConnection iDBConnection, Reifier.Style style) {
        return new ModelMakerImpl(new GraphRDBMaker(iDBConnection, style));
    }

    public static IDBConnection createSimpleRDBConnection(String string, String string2, String string3, String string4) {
        return new DBConnection(string, string2, string3, string4);
    }

    public static IDBConnection createSimpleRDBConnection() {
        return ModelFactory.createSimpleRDBConnection(ModelFactory.guessDBURL(), ModelFactory.guessDBUser(), ModelFactory.guessDBPassword(), ModelFactory.guessDBType());
    }

    public static InfModel createRDFSModel(Model model) {
        Reasoner reasoner = ReasonerRegistry.getRDFSReasoner();
        InfGraph infGraph = reasoner.bind(model.getGraph());
        return new InfModelImpl(infGraph);
    }

    public static InfModel createRDFSModel(Model model, Model model2) {
        Reasoner reasoner = ReasonerRegistry.getRDFSReasoner();
        InfGraph infGraph = reasoner.bindSchema(model.getGraph()).bind(model2.getGraph());
        return new InfModelImpl(infGraph);
    }

    public static InfModel createInfModel(Reasoner reasoner, Model model) {
        InfGraph infGraph = reasoner.bind(model.getGraph());
        return new InfModelImpl(infGraph);
    }

    public static InfModel createInfModel(Reasoner reasoner, Model model, Model model2) {
        InfGraph infGraph = reasoner.bindSchema(model.getGraph()).bind(model2.getGraph());
        return new InfModelImpl(infGraph);
    }

    public static OntModel createOntologyModel() {
        return ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
    }

    public static OntModel createOntologyModel(String string) {
        return ModelFactory.createOntologyModel(OntModelSpec.getDefaultSpec(string), null);
    }

    public static OntModel createOntologyModel(OntModelSpec ontModelSpec, ModelMaker modelMaker, Model model) {
        OntModelSpec ontModelSpec2 = new OntModelSpec(ontModelSpec);
        ontModelSpec2.setModelMaker(modelMaker);
        return ModelFactory.createOntologyModel(ontModelSpec2, model);
    }

    public static OntModel createOntologyModel(OntModelSpec ontModelSpec, Model model) {
        return new OntModelImpl(ontModelSpec, model);
    }

    public static DAMLModel createDAMLModel() {
        return new DAMLModelImpl(OntModelSpec.getDefaultSpec("http://www.daml.org/2001/03/daml+oil#"), null);
    }
}

