/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.ontology.tidy.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.CNodeI;
import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Set;

class MinimalSubGraph
extends AbsChecker {
    private final Checker parent;
    private final Set todo = new HashSet();
    private final Set done = new HashSet();

    MinimalSubGraph(boolean bl, Triple triple, Checker checker) {
        super(bl, new SimpleGraphMaker());
        this.parent = checker;
        if (!this.add(triple, false)) {
            this.hasBeenChecked.add(triple);
        } else {
            this.todo(triple);
            this.extend();
        }
    }

    Graph getContradiction() {
        return this.hasBeenChecked;
    }

    private void todo(Triple triple) {
        this.todo(triple.getSubject());
        this.todo(triple.getObject());
        this.todo(triple.getPredicate());
    }

    private void todo(Node node) {
        if (!this.done.contains(node)) {
            this.todo.add(node);
        }
    }

    private void extend() {
        Node node;
        do {
            node = (Node)this.todo.iterator().next();
            this.todo.remove(node);
            this.done.add(node);
        } while (!this.unfinished(node) || !this.extend(node));
    }

    private boolean extend(Node node) {
        return this.extend(node, null, null, node) || this.extend(null, node, null, node) || this.extend(null, null, node, node);
    }

    private boolean unfinished(Node node) {
        CNodeI cNodeI = this.parent.getCNode(node);
        CNodeI cNodeI2 = this.getCNode(node);
        return cNodeI.getCategories() != cNodeI2.getCategories();
    }

    private boolean nontrivialReally(Node node, Node node2) {
        return node != null && this.unfinished(node2);
    }

    private boolean extend(Node node, Node node2, Node node3, Node node4) {
        ExtendedIterator extendedIterator = this.parent.hasBeenChecked.find(node, node2, node3);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            int n = this.addX(triple, true);
            switch (n) {
                case 0: {
                    this.hasBeenChecked.add(triple);
                    return true;
                }
                case 1: {
                    if (!this.nontrivialReally(node, triple.getSubject()) && !this.nontrivialReally(node2, triple.getPredicate()) && !this.nontrivialReally(node3, triple.getObject()) || !this.unfinished(node4)) {
                        this.hasBeenChecked.delete(triple);
                        break;
                    }
                }
                case 2: {
                    this.todo(triple);
                }
            }
        }
        return false;
    }

    void actions(long l, CNodeI cNodeI, CNodeI cNodeI2, Triple triple) {
    }
}

