/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestClassExpression
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;

    public static TestSuite suite() {
        return new TestClassExpression("TestClassExpression");
    }

    public TestClassExpression(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntClass.super-class", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addSuperClass(ontClass2);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.SUB_CLASS_OF()));
                1.assertEquals((String)"A should have super-class B", (Object)ontClass2, (Object)ontClass.getSuperClass());
                ontClass.addSuperClass(ontClass3);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)ontClass.getCardinality(profile.SUB_CLASS_OF()));
                this.iteratorTest(ontClass.listSuperClasses(), new Object[]{ontClass3, ontClass2});
                ontClass.setSuperClass(ontClass3);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.SUB_CLASS_OF()));
                1.assertEquals((String)"A shuold have super-class C", (Object)ontClass3, (Object)ontClass.getSuperClass());
                1.assertTrue((String)"A shuold not have super-class B", (!ontClass.hasSuperClass(ontClass2, false) ? 1 : 0) != 0);
                ontClass.removeSuperClass(ontClass2);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.SUB_CLASS_OF()));
                ontClass.removeSuperClass(ontClass3);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)ontClass.getCardinality(profile.SUB_CLASS_OF()));
            }
        }, new OntTestBase.OntTestCase("OntClass.sub-class", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addSubClass(ontClass2);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass2.getCardinality(profile.SUB_CLASS_OF()));
                2.assertEquals((String)"A should have sub-class B", (Object)ontClass2, (Object)ontClass.getSubClass());
                ontClass.addSubClass(ontClass3);
                2.assertEquals((String)"Cardinality should be 2", (int)2, (int)(ontClass2.getCardinality(profile.SUB_CLASS_OF()) + ontClass3.getCardinality(profile.SUB_CLASS_OF())));
                this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass3, ontClass2});
                ontClass.setSubClass(ontClass3);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)(ontClass2.getCardinality(profile.SUB_CLASS_OF()) + ontClass3.getCardinality(profile.SUB_CLASS_OF())));
                2.assertEquals((String)"A shuold have sub-class C", (Object)ontClass3, (Object)ontClass.getSubClass());
                2.assertTrue((String)"A shuold not have sub-class B", (!ontClass.hasSubClass(ontClass2, false) ? 1 : 0) != 0);
                ontClass.removeSubClass(ontClass2);
                2.assertTrue((String)"A should have sub-class C", (boolean)ontClass.hasSubClass(ontClass3, false));
                ontClass.removeSubClass(ontClass3);
                2.assertTrue((String)"A should not have sub-class C", (!ontClass.hasSubClass(ontClass3, false) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addEquivalentClass(ontClass2);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                3.assertEquals((String)"A have equivalentClass B", (Object)ontClass2, (Object)ontClass.getEquivalentClass());
                ontClass.addEquivalentClass(ontClass3);
                3.assertEquals((String)"Cardinality should be 2", (int)2, (int)ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                this.iteratorTest(ontClass.listEquivalentClasses(), new Object[]{ontClass3, ontClass2});
                ontClass.setEquivalentClass(ontClass3);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                3.assertEquals((String)"A should have equivalentClass C", (Object)ontClass3, (Object)ontClass.getEquivalentClass());
                3.assertTrue((String)"A should not have equivalentClass B", (!ontClass.hasEquivalentClass(ontClass2) ? 1 : 0) != 0);
                ontClass.removeEquivalentClass(ontClass2);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                ontClass.removeEquivalentClass(ontClass3);
                3.assertEquals((String)"Cardinality should be 0", (int)0, (int)ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjointWith", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addDisjointWith(ontClass2);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.DISJOINT_WITH()));
                4.assertEquals((String)"A have be disjoint with B", (Object)ontClass2, (Object)ontClass.getDisjointWith());
                ontClass.addDisjointWith(ontClass3);
                4.assertEquals((String)"Cardinality should be 2", (int)2, (int)ontClass.getCardinality(profile.DISJOINT_WITH()));
                this.iteratorTest(ontClass.listDisjointWith(), new Object[]{ontClass3, ontClass2});
                ontClass.setDisjointWith(ontClass3);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.DISJOINT_WITH()));
                4.assertEquals((String)"A should be disjoint with C", (Object)ontClass3, (Object)ontClass.getDisjointWith());
                4.assertTrue((String)"A should not be disjoint with B", (!ontClass.isDisjointWith(ontClass2) ? 1 : 0) != 0);
                ontClass.removeDisjointWith(ontClass2);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontClass.getCardinality(profile.DISJOINT_WITH()));
                ontClass.removeDisjointWith(ontClass3);
                4.assertEquals((String)"Cardinality should be 0", (int)0, (int)ontClass.getCardinality(profile.DISJOINT_WITH()));
            }
        }, new OntTestBase.OntTestCase("EnumeratedClass.oneOf", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                enumeratedClass.addOneOf(ontResource);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)enumeratedClass.getCardinality(profile.ONE_OF()));
                5.assertEquals((String)"Size should be 1", (int)1, (int)enumeratedClass.getOneOf().size());
                5.assertTrue((String)"A should have a as enumerated member", (boolean)enumeratedClass.getOneOf().contains(ontResource));
                enumeratedClass.addOneOf(ontResource2);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)enumeratedClass.getCardinality(profile.ONE_OF()));
                5.assertEquals((String)"Size should be 2", (int)2, (int)enumeratedClass.getOneOf().size());
                this.iteratorTest(enumeratedClass.listOneOf(), new Object[]{ontResource, ontResource2});
                enumeratedClass.setOneOf(ontModel.createList(new RDFNode[]{ontResource2}));
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)enumeratedClass.getCardinality(profile.ONE_OF()));
                5.assertEquals((String)"Size should be 1", (int)1, (int)enumeratedClass.getOneOf().size());
                5.assertTrue((String)"A should have b in the enum", (boolean)enumeratedClass.hasOneOf(ontResource2));
                5.assertTrue((String)"A should not have a in the enum", (!enumeratedClass.hasOneOf(ontResource) ? 1 : 0) != 0);
                enumeratedClass.removeOneOf(ontResource);
                5.assertTrue((String)"Should have b as an enum value", (boolean)enumeratedClass.hasOneOf(ontResource2));
                enumeratedClass.removeOneOf(ontResource2);
                5.assertTrue((String)"Should not have b as an enum value", (!enumeratedClass.hasOneOf(ontResource2) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("IntersectionClass.intersectionOf", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                IntersectionClass intersectionClass = ontModel.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                intersectionClass.addOperand(ontClass);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)intersectionClass.getCardinality(profile.INTERSECTION_OF()));
                6.assertEquals((String)"Size should be 1", (int)1, (int)intersectionClass.getOperands().size());
                6.assertTrue((String)"A should have a as intersection member", (boolean)intersectionClass.getOperands().contains(ontClass));
                intersectionClass.addOperand(ontClass2);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)intersectionClass.getCardinality(profile.INTERSECTION_OF()));
                6.assertEquals((String)"Size should be 2", (int)2, (int)intersectionClass.getOperands().size());
                this.iteratorTest(intersectionClass.listOperands(), new Object[]{ontClass, ontClass2});
                intersectionClass.setOperands(ontModel.createList(new RDFNode[]{ontClass2}));
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)intersectionClass.getCardinality(profile.INTERSECTION_OF()));
                6.assertEquals((String)"Size should be 1", (int)1, (int)intersectionClass.getOperands().size());
                6.assertTrue((String)"A should have C in the intersection", (boolean)intersectionClass.hasOperand(ontClass2));
                6.assertTrue((String)"A should not have B in the intersection", (!intersectionClass.hasOperand(ontClass) ? 1 : 0) != 0);
                intersectionClass.removeOperand(ontClass);
                6.assertTrue((String)"Should have C as an operand", (boolean)intersectionClass.hasOperand(ontClass2));
                intersectionClass.removeOperand(ontClass2);
                6.assertTrue((String)"Should not have C as an operand", (!intersectionClass.hasOperand(ontClass2) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("UnionClass.unionOf", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                UnionClass unionClass = ontModel.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                unionClass.addOperand(ontClass);
                7.assertEquals((String)"Cardinality should be 1", (int)1, (int)unionClass.getCardinality(profile.UNION_OF()));
                7.assertEquals((String)"Size should be 1", (int)1, (int)unionClass.getOperands().size());
                7.assertTrue((String)"A should have a as union member", (boolean)unionClass.getOperands().contains(ontClass));
                unionClass.addOperand(ontClass2);
                7.assertEquals((String)"Cardinality should be 1", (int)1, (int)unionClass.getCardinality(profile.UNION_OF()));
                7.assertEquals((String)"Size should be 2", (int)2, (int)unionClass.getOperands().size());
                this.iteratorTest(unionClass.listOperands(), new Object[]{ontClass, ontClass2});
                unionClass.setOperands(ontModel.createList(new RDFNode[]{ontClass2}));
                7.assertEquals((String)"Cardinality should be 1", (int)1, (int)unionClass.getCardinality(profile.UNION_OF()));
                7.assertEquals((String)"Size should be 1", (int)1, (int)unionClass.getOperands().size());
                7.assertTrue((String)"A should have C in the union", (boolean)unionClass.hasOperand(ontClass2));
                7.assertTrue((String)"A should not have B in the union", (!unionClass.hasOperand(ontClass) ? 1 : 0) != 0);
                unionClass.removeOperand(ontClass);
                7.assertTrue((String)"Should have C as an operand", (boolean)unionClass.hasOperand(ontClass2));
                unionClass.removeOperand(ontClass2);
                7.assertTrue((String)"Should not have C as an operand", (!unionClass.hasOperand(ontClass2) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("ComplementClass.complementOf", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ComplementClass complementClass = ontModel.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                boolean bl = false;
                try {
                    complementClass.addOperand(ontClass);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
                8.assertTrue((String)"Should fail to add to a complement", (boolean)bl);
                bl = false;
                try {
                    complementClass.addOperands(new ArrayList().iterator());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
                8.assertTrue((String)"Should fail to add to a complement", (boolean)bl);
                bl = false;
                try {
                    complementClass.setOperands(ontModel.createList(new RDFNode[]{ontClass2}));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
                8.assertTrue((String)"Should fail to set a list to a complement", (boolean)bl);
                complementClass.setOperand(ontClass);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)complementClass.getCardinality(profile.COMPLEMENT_OF()));
                8.assertEquals((String)"Complement should be B", (Object)ontClass, (Object)complementClass.getOperand());
                this.iteratorTest(complementClass.listOperands(), new Object[]{ontClass});
                complementClass.setOperand(ontClass2);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)complementClass.getCardinality(profile.COMPLEMENT_OF()));
                8.assertTrue((String)"A should have C in the complement", (boolean)complementClass.hasOperand(ontClass2));
                8.assertTrue((String)"A should not have B in the complement", (!complementClass.hasOperand(ontClass) ? 1 : 0) != 0);
                complementClass.removeOperand(ontClass);
                8.assertTrue((String)"Should have C as an operand", (boolean)complementClass.hasOperand(ontClass2));
                complementClass.removeOperand(ontClass2);
                8.assertTrue((String)"Should not have C as an operand", (!complementClass.hasOperand(ontClass2) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.onProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, ontClass);
                9.assertEquals((String)"Restriction should be on property p", (Object)objectProperty, (Object)allValuesFromRestriction.getOnProperty());
                9.assertTrue((String)"Restriction should be on property p", (boolean)allValuesFromRestriction.onProperty(objectProperty));
                9.assertTrue((String)"Restriction should not be on property q", (!allValuesFromRestriction.onProperty(objectProperty2) ? 1 : 0) != 0);
                9.assertEquals((String)"cardinality should be 1 ", (int)1, (int)allValuesFromRestriction.getCardinality(profile.ON_PROPERTY()));
                allValuesFromRestriction.setOnProperty(objectProperty2);
                9.assertEquals((String)"Restriction should be on property q", (Object)objectProperty2, (Object)allValuesFromRestriction.getOnProperty());
                9.assertTrue((String)"Restriction should not be on property p", (!allValuesFromRestriction.onProperty(objectProperty) ? 1 : 0) != 0);
                9.assertTrue((String)"Restriction should not on property q", (boolean)allValuesFromRestriction.onProperty(objectProperty2));
                9.assertEquals((String)"cardinality should be 1 ", (int)1, (int)allValuesFromRestriction.getCardinality(profile.ON_PROPERTY()));
                allValuesFromRestriction.removeOnProperty(objectProperty);
                9.assertTrue((String)"Should have q as on property", (boolean)allValuesFromRestriction.onProperty(objectProperty2));
                allValuesFromRestriction.removeOnProperty(objectProperty2);
                9.assertTrue((String)"Should not have q as on property", (!allValuesFromRestriction.onProperty(objectProperty2) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, ontClass);
                10.assertEquals((String)"Restriction should be all values from B", (Object)ontClass, (Object)allValuesFromRestriction.getAllValuesFrom());
                10.assertTrue((String)"Restriction should be all values from B", (boolean)allValuesFromRestriction.hasAllValuesFrom(ontClass));
                10.assertTrue((String)"Restriction should not be all values from C", (!allValuesFromRestriction.hasAllValuesFrom(ontClass2) ? 1 : 0) != 0);
                10.assertEquals((String)"cardinality should be 1 ", (int)1, (int)allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.setAllValuesFrom(ontClass2);
                10.assertEquals((String)"Restriction should be all values from C", (Object)ontClass2, (Object)allValuesFromRestriction.getAllValuesFrom());
                10.assertTrue((String)"Restriction should not be all values from B", (!allValuesFromRestriction.hasAllValuesFrom(ontClass) ? 1 : 0) != 0);
                10.assertTrue((String)"Restriction should be all values from C", (boolean)allValuesFromRestriction.hasAllValuesFrom(ontClass2));
                10.assertEquals((String)"cardinality should be 1 ", (int)1, (int)allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.removeAllValuesFrom(ontClass2);
                10.assertTrue((String)"Restriction should not be some values from C", (!allValuesFromRestriction.hasAllValuesFrom(ontClass2) ? 1 : 0) != 0);
                10.assertEquals((String)"cardinality should be 0 ", (int)0, (int)allValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("HasValueRestriction.hasValue", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                Individual individual2 = ontModel.createIndividual(ontClass2);
                HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, individual);
                11.assertEquals((String)"Restriction should be has value b", (Object)individual, (Object)hasValueRestriction.getHasValue());
                11.assertTrue((String)"Restriction should be to have value b", (boolean)hasValueRestriction.hasValue(individual));
                11.assertTrue((String)"Restriction should not be have value c", (!hasValueRestriction.hasValue(individual2) ? 1 : 0) != 0);
                11.assertEquals((String)"cardinality should be 1 ", (int)1, (int)hasValueRestriction.getCardinality(profile.HAS_VALUE()));
                hasValueRestriction.setHasValue(individual2);
                11.assertEquals((String)"Restriction should be has value c", (Object)individual2, (Object)hasValueRestriction.getHasValue());
                11.assertTrue((String)"Restriction should not be to have value b", (!hasValueRestriction.hasValue(individual) ? 1 : 0) != 0);
                11.assertTrue((String)"Restriction should not be have value c", (boolean)hasValueRestriction.hasValue(individual2));
                11.assertEquals((String)"cardinality should be 1 ", (int)1, (int)hasValueRestriction.getCardinality(profile.HAS_VALUE()));
                hasValueRestriction.removeHasValue(individual2);
                11.assertTrue((String)"Restriction should not be to have value b", (!hasValueRestriction.hasValue(individual) ? 1 : 0) != 0);
                11.assertTrue((String)"Restriction should not be have value c", (!hasValueRestriction.hasValue(individual2) ? 1 : 0) != 0);
                11.assertEquals((String)"cardinality should be 0 ", (int)0, (int)hasValueRestriction.getCardinality(profile.HAS_VALUE()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.someValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, ontClass);
                12.assertEquals((String)"Restriction should be some values from B", (Object)ontClass, (Object)someValuesFromRestriction.getSomeValuesFrom());
                12.assertTrue((String)"Restriction should be some values from B", (boolean)someValuesFromRestriction.hasSomeValuesFrom(ontClass));
                12.assertTrue((String)"Restriction should not be some values from C", (!someValuesFromRestriction.hasSomeValuesFrom(ontClass2) ? 1 : 0) != 0);
                12.assertEquals((String)"cardinality should be 1 ", (int)1, (int)someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.setSomeValuesFrom(ontClass2);
                12.assertEquals((String)"Restriction should be some values from C", (Object)ontClass2, (Object)someValuesFromRestriction.getSomeValuesFrom());
                12.assertTrue((String)"Restriction should not be some values from B", (!someValuesFromRestriction.hasSomeValuesFrom(ontClass) ? 1 : 0) != 0);
                12.assertTrue((String)"Restriction should be some values from C", (boolean)someValuesFromRestriction.hasSomeValuesFrom(ontClass2));
                12.assertEquals((String)"cardinality should be 1 ", (int)1, (int)someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.removeSomeValuesFrom(ontClass2);
                12.assertTrue((String)"Restriction should not be some values from C", (!someValuesFromRestriction.hasSomeValuesFrom(ontClass2) ? 1 : 0) != 0);
                12.assertEquals((String)"cardinality should be 0 ", (int)0, (int)someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("CardinalityRestriction.cardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction cardinalityRestriction = ontModel.createCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, 3);
                13.assertEquals((String)"Restriction should be cardinality 3", (int)3, (int)cardinalityRestriction.getCardinality());
                13.assertTrue((String)"Restriction should be cardinality 3", (boolean)cardinalityRestriction.hasCardinality(3));
                13.assertTrue((String)"Restriction should not be cardinality 2", (!cardinalityRestriction.hasCardinality(2) ? 1 : 0) != 0);
                13.assertEquals((String)"cardinality should be 1 ", (int)1, (int)cardinalityRestriction.getCardinality(profile.CARDINALITY()));
                cardinalityRestriction.setCardinality(2);
                13.assertEquals((String)"Restriction should be cardinality 2", (int)2, (int)cardinalityRestriction.getCardinality());
                13.assertTrue((String)"Restriction should not be cardinality 3", (!cardinalityRestriction.hasCardinality(3) ? 1 : 0) != 0);
                13.assertTrue((String)"Restriction should be cardinality 2", (boolean)cardinalityRestriction.hasCardinality(2));
                13.assertEquals((String)"cardinality should be 1 ", (int)1, (int)cardinalityRestriction.getCardinality(profile.CARDINALITY()));
                cardinalityRestriction.removeCardinality(2);
                13.assertTrue((String)"Restriction should not be cardinality 3", (!cardinalityRestriction.hasCardinality(3) ? 1 : 0) != 0);
                13.assertTrue((String)"Restriction should not be cardinality 2", (!cardinalityRestriction.hasCardinality(2) ? 1 : 0) != 0);
                13.assertEquals((String)"cardinality should be 0 ", (int)0, (int)cardinalityRestriction.getCardinality(profile.CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MinCardinalityRestriction.minCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction minCardinalityRestriction = ontModel.createMinCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, 3);
                14.assertEquals((String)"Restriction should be min cardinality 3", (int)3, (int)minCardinalityRestriction.getMinCardinality());
                14.assertTrue((String)"Restriction should be min cardinality 3", (boolean)minCardinalityRestriction.hasMinCardinality(3));
                14.assertTrue((String)"Restriction should not be min cardinality 2", (!minCardinalityRestriction.hasMinCardinality(2) ? 1 : 0) != 0);
                14.assertEquals((String)"cardinality should be 1 ", (int)1, (int)minCardinalityRestriction.getCardinality(profile.MIN_CARDINALITY()));
                minCardinalityRestriction.setMinCardinality(2);
                14.assertEquals((String)"Restriction should be min cardinality 2", (int)2, (int)minCardinalityRestriction.getMinCardinality());
                14.assertTrue((String)"Restriction should not be min cardinality 3", (!minCardinalityRestriction.hasMinCardinality(3) ? 1 : 0) != 0);
                14.assertTrue((String)"Restriction should be min cardinality 2", (boolean)minCardinalityRestriction.hasMinCardinality(2));
                14.assertEquals((String)"cardinality should be 1 ", (int)1, (int)minCardinalityRestriction.getCardinality(profile.MIN_CARDINALITY()));
                minCardinalityRestriction.removeMinCardinality(2);
                14.assertTrue((String)"Restriction should not be cardinality 3", (!minCardinalityRestriction.hasMinCardinality(3) ? 1 : 0) != 0);
                14.assertTrue((String)"Restriction should not be cardinality 2", (!minCardinalityRestriction.hasMinCardinality(2) ? 1 : 0) != 0);
                14.assertEquals((String)"cardinality should be 0 ", (int)0, (int)minCardinalityRestriction.getCardinality(profile.MIN_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MaxCardinalityRestriction.maxCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction maxCardinalityRestriction = ontModel.createMaxCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, 3);
                15.assertEquals((String)"Restriction should be max cardinality 3", (int)3, (int)maxCardinalityRestriction.getMaxCardinality());
                15.assertTrue((String)"Restriction should be max cardinality 3", (boolean)maxCardinalityRestriction.hasMaxCardinality(3));
                15.assertTrue((String)"Restriction should not be max cardinality 2", (!maxCardinalityRestriction.hasMaxCardinality(2) ? 1 : 0) != 0);
                15.assertEquals((String)"cardinality should be 1 ", (int)1, (int)maxCardinalityRestriction.getCardinality(profile.MAX_CARDINALITY()));
                maxCardinalityRestriction.setMaxCardinality(2);
                15.assertEquals((String)"Restriction should be max cardinality 2", (int)2, (int)maxCardinalityRestriction.getMaxCardinality());
                15.assertTrue((String)"Restriction should not be max cardinality 3", (!maxCardinalityRestriction.hasMaxCardinality(3) ? 1 : 0) != 0);
                15.assertTrue((String)"Restriction should be max cardinality 2", (boolean)maxCardinalityRestriction.hasMaxCardinality(2));
                15.assertEquals((String)"cardinality should be 1 ", (int)1, (int)maxCardinalityRestriction.getCardinality(profile.MAX_CARDINALITY()));
                maxCardinalityRestriction.removeMaxCardinality(2);
                15.assertTrue((String)"Restriction should not be cardinality 3", (!maxCardinalityRestriction.hasMaxCardinality(3) ? 1 : 0) != 0);
                15.assertTrue((String)"Restriction should not be cardinality 2", (!maxCardinalityRestriction.hasMaxCardinality(2) ? 1 : 0) != 0);
                15.assertEquals((String)"cardinality should be 0 ", (int)0, (int)maxCardinalityRestriction.getCardinality(profile.MAX_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("OntClass.subclass.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/ClassExpression/test.rdf";
                ontModel.read(string2);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassB");
                this.iteratorTest(ontClass.listSuperClasses(), new Object[]{ontClass2});
                this.iteratorTest(ontClass2.listSubClasses(), new Object[]{ontClass});
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass.fromFile", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/ClassExpression/test.rdf";
                ontModel.read(string2);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassC");
                17.assertTrue((String)"A should be equiv to C", (boolean)ontClass.hasEquivalentClass(ontClass2));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjoint.fromFile", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/ClassExpression/test.rdf";
                ontModel.read(string2);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassD");
                18.assertTrue((String)"A should be disjoint with D", (boolean)ontClass.isDisjointWith(ontClass2));
            }
        }, new OntTestBase.OntTestCase("OntClass.isEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", ontClass);
                Individual individual2 = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", ontClass);
                EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", ontModel.createList(new RDFNode[]{individual, individual2}));
                19.assertTrue((String)"enumerated class test not correct", (boolean)enumeratedClass.isEnumeratedClass());
                19.assertTrue((String)"intersection class test not correct", (!enumeratedClass.isIntersectionClass() ? 1 : 0) != 0);
                19.assertTrue((String)"union class test not correct", (!enumeratedClass.isUnionClass() ? 1 : 0) != 0);
                19.assertTrue((String)"complement class test not correct", (!enumeratedClass.isComplementClass() ? 1 : 0) != 0);
                19.assertTrue((String)"restriction test not correct", (!enumeratedClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isIntersectionClass", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                IntersectionClass intersectionClass = ontModel.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", ontModel.createList(new RDFNode[]{ontClass, ontClass2}));
                20.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !intersectionClass.isEnumeratedClass() ? 1 : 0) != 0);
                20.assertTrue((String)"intersection class test not correct", (boolean)intersectionClass.isIntersectionClass());
                20.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !intersectionClass.isUnionClass() ? 1 : 0) != 0);
                20.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !intersectionClass.isComplementClass() ? 1 : 0) != 0);
                20.assertTrue((String)"restriction test not correct", (!intersectionClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isUnionClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                UnionClass unionClass = ontModel.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", ontModel.createList(new RDFNode[]{ontClass, ontClass2}));
                21.assertTrue((String)"enumerated class test not correct", (!unionClass.isEnumeratedClass() ? 1 : 0) != 0);
                21.assertTrue((String)"intersection class test not correct", (!unionClass.isIntersectionClass() ? 1 : 0) != 0);
                21.assertTrue((String)"union class test not correct", (boolean)unionClass.isUnionClass());
                21.assertTrue((String)"complement class test not correct", (!unionClass.isComplementClass() ? 1 : 0) != 0);
                21.assertTrue((String)"restriction test not correct", (!unionClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isComplementClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ComplementClass complementClass = ontModel.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", ontClass);
                22.assertTrue((String)"enumerated class test not correct", (!complementClass.isEnumeratedClass() ? 1 : 0) != 0);
                22.assertTrue((String)"intersection class test not correct", (!complementClass.isIntersectionClass() ? 1 : 0) != 0);
                22.assertTrue((String)"union class test not correct", (!complementClass.isUnionClass() ? 1 : 0) != 0);
                22.assertTrue((String)"complement class test not correct", (boolean)complementClass.isComplementClass());
                22.assertTrue((String)"restriction test not correct", (!complementClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isRestriction", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Restriction restriction = ontModel.createRestriction(null);
                23.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !restriction.isEnumeratedClass() ? 1 : 0) != 0);
                23.assertTrue((String)"intersection class test not correct", (!restriction.isIntersectionClass() ? 1 : 0) != 0);
                23.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !restriction.isUnionClass() ? 1 : 0) != 0);
                23.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !restriction.isComplementClass() ? 1 : 0) != 0);
                23.assertTrue((String)"restriction test not correct", (boolean)restriction.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                24.assertTrue((String)"enumerated class test not correct", (!ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                24.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                24.assertTrue((String)"union class test not correct", (!ontClass.isUnionClass() ? 1 : 0) != 0);
                24.assertTrue((String)"complement class test not correct", (!ontClass.isComplementClass() ? 1 : 0) != 0);
                24.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", ontClass2);
                Individual individual2 = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", ontClass2);
                ontClass = ontClass.convertToEnumeratedClass(ontModel.createList(new RDFNode[]{individual, individual2}));
                24.assertTrue((String)"enumerated class test not correct", (boolean)ontClass.isEnumeratedClass());
                24.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                24.assertTrue((String)"union class test not correct", (!ontClass.isUnionClass() ? 1 : 0) != 0);
                24.assertTrue((String)"complement class test not correct", (!ontClass.isComplementClass() ? 1 : 0) != 0);
                24.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toIntersectionClass", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                25.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                25.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                25.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !ontClass.isUnionClass() ? 1 : 0) != 0);
                25.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !ontClass.isComplementClass() ? 1 : 0) != 0);
                25.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass = ontClass.convertToIntersectionClass(ontModel.createList(new RDFNode[]{ontClass2, ontClass3}));
                25.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                25.assertTrue((String)"intersection class test not correct", (boolean)ontClass.isIntersectionClass());
                25.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !ontClass.isUnionClass() ? 1 : 0) != 0);
                25.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !ontClass.isComplementClass() ? 1 : 0) != 0);
                25.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toUnionClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                26.assertTrue((String)"enumerated class test not correct", (!ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                26.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                26.assertTrue((String)"union class test not correct", (!ontClass.isUnionClass() ? 1 : 0) != 0);
                26.assertTrue((String)"complement class test not correct", (!ontClass.isComplementClass() ? 1 : 0) != 0);
                26.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass = ontClass.convertToUnionClass(ontModel.createList(new RDFNode[]{ontClass2, ontClass3}));
                26.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                26.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                26.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || ontClass.isUnionClass() ? 1 : 0) != 0);
                26.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !ontClass.isComplementClass() ? 1 : 0) != 0);
                26.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toComplementClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                27.assertTrue((String)"enumerated class test not correct", (!ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                27.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                27.assertTrue((String)"union class test not correct", (!ontClass.isUnionClass() ? 1 : 0) != 0);
                27.assertTrue((String)"complement class test not correct", (!ontClass.isComplementClass() ? 1 : 0) != 0);
                27.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ontClass = ontClass.convertToComplementClass(ontClass2);
                27.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                27.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                27.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !ontClass.isUnionClass() ? 1 : 0) != 0);
                27.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || ontClass.isComplementClass() ? 1 : 0) != 0);
                27.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toRestriction", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                28.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                28.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                28.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !ontClass.isUnionClass() ? 1 : 0) != 0);
                28.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !ontClass.isComplementClass() ? 1 : 0) != 0);
                28.assertTrue((String)"restriction test not correct", (!ontClass.isRestriction() ? 1 : 0) != 0);
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ontClass = ontClass.convertToRestriction(objectProperty);
                28.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !ontClass.isEnumeratedClass() ? 1 : 0) != 0);
                28.assertTrue((String)"intersection class test not correct", (!ontClass.isIntersectionClass() ? 1 : 0) != 0);
                28.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !ontClass.isUnionClass() ? 1 : 0) != 0);
                28.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !ontClass.isComplementClass() ? 1 : 0) != 0);
                28.assertTrue((String)"restriction test not correct", (boolean)ontClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction(null, objectProperty, ontClass);
                29.assertTrue((String)"all values from test not correct", (boolean)allValuesFromRestriction.isAllValuesFromRestriction());
                29.assertTrue((String)"some values from test not correct", (!allValuesFromRestriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                29.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !allValuesFromRestriction.isHasValueRestriction() ? 1 : 0) != 0);
                29.assertTrue((String)"cardinality test not correct", (!allValuesFromRestriction.isCardinalityRestriction() ? 1 : 0) != 0);
                29.assertTrue((String)"min cardinality test not correct", (!allValuesFromRestriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                29.assertTrue((String)"max cardinality test not correct", (!allValuesFromRestriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction(null, objectProperty, ontClass);
                30.assertTrue((String)"all values from test not correct", (!someValuesFromRestriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                30.assertTrue((String)"some values from test not correct", (boolean)someValuesFromRestriction.isSomeValuesFromRestriction());
                30.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !someValuesFromRestriction.isHasValueRestriction() ? 1 : 0) != 0);
                30.assertTrue((String)"cardinality test not correct", (!someValuesFromRestriction.isCardinalityRestriction() ? 1 : 0) != 0);
                30.assertTrue((String)"min cardinality test not correct", (!someValuesFromRestriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                30.assertTrue((String)"max cardinality test not correct", (!someValuesFromRestriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isHasValue", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction(null, objectProperty, individual);
                31.assertTrue((String)"all values from test not correct", (!hasValueRestriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                31.assertTrue((String)"some values from test not correct", (!hasValueRestriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                31.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || hasValueRestriction.isHasValueRestriction() ? 1 : 0) != 0);
                31.assertTrue((String)"cardinality test not correct", (!hasValueRestriction.isCardinalityRestriction() ? 1 : 0) != 0);
                31.assertTrue((String)"min cardinality test not correct", (!hasValueRestriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                31.assertTrue((String)"max cardinality test not correct", (!hasValueRestriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction cardinalityRestriction = ontModel.createCardinalityRestriction(null, objectProperty, 3);
                32.assertTrue((String)"all values from test not correct", (!cardinalityRestriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                32.assertTrue((String)"some values from test not correct", (!cardinalityRestriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                32.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !cardinalityRestriction.isHasValueRestriction() ? 1 : 0) != 0);
                32.assertTrue((String)"cardinality test not correct", (boolean)cardinalityRestriction.isCardinalityRestriction());
                32.assertTrue((String)"min cardinality test not correct", (!cardinalityRestriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                32.assertTrue((String)"max cardinality test not correct", (!cardinalityRestriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isMinCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction minCardinalityRestriction = ontModel.createMinCardinalityRestriction(null, objectProperty, 1);
                33.assertTrue((String)"all values from test not correct", (!minCardinalityRestriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                33.assertTrue((String)"some values from test not correct", (!minCardinalityRestriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                33.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !minCardinalityRestriction.isHasValueRestriction() ? 1 : 0) != 0);
                33.assertTrue((String)"cardinality test not correct", (!minCardinalityRestriction.isCardinalityRestriction() ? 1 : 0) != 0);
                33.assertTrue((String)"min cardinality test not correct", (boolean)minCardinalityRestriction.isMinCardinalityRestriction());
                33.assertTrue((String)"max cardinality test not correct", (!minCardinalityRestriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isMaxCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction maxCardinalityRestriction = ontModel.createMaxCardinalityRestriction(null, objectProperty, 5);
                34.assertTrue((String)"all values from test not correct", (!maxCardinalityRestriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                34.assertTrue((String)"some values from test not correct", (!maxCardinalityRestriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                34.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !maxCardinalityRestriction.isHasValueRestriction() ? 1 : 0) != 0);
                34.assertTrue((String)"cardinality test not correct", (!maxCardinalityRestriction.isCardinalityRestriction() ? 1 : 0) != 0);
                34.assertTrue((String)"min cardinality test not correct", (!maxCardinalityRestriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                34.assertTrue((String)"max cardinality test not correct", (boolean)maxCardinalityRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                35.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                restriction = restriction.convertToAllValuesFromRestriction(ontClass);
                35.assertTrue((String)"all values from test not correct", (boolean)restriction.isAllValuesFromRestriction());
                35.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                35.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                36.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                restriction = restriction.convertToSomeValuesFromRestriction(ontClass);
                36.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"some values from test not correct", (boolean)restriction.isSomeValuesFromRestriction());
                36.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                36.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToHasValue", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                37.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                restriction = restriction.convertToHasValueRestriction(individual);
                37.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || restriction.isHasValueRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                37.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                38.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                restriction = restriction.convertToCardinalityRestriction(3);
                38.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"cardinality test not correct", (boolean)restriction.isCardinalityRestriction());
                38.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                38.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMinCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                39.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                restriction = restriction.convertToMinCardinalityRestriction(3);
                39.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"min cardinality test not correct", (boolean)restriction.isMinCardinalityRestriction());
                39.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMaxCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                40.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"max cardinality test not correct", (!restriction.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                restriction = restriction.convertToMaxCardinalityRestriction(3);
                40.assertTrue((String)"all values from test not correct", (!restriction.isAllValuesFromRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"some values from test not correct", (!restriction.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !restriction.isHasValueRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"cardinality test not correct", (!restriction.isCardinalityRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"min cardinality test not correct", (!restriction.isMinCardinalityRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"max cardinality test not correct", (boolean)restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.listInstances", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                Individual individual2 = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#a1", ontClass);
                Individual individual3 = ontModel.createIndividual(ontClass2);
                ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#b1", ontClass2);
                individual3.addRDFType(ontClass);
                this.iteratorTest(ontClass.listInstances(), new Object[]{individual, individual2, individual3});
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                OntProperty ontProperty4 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                ontProperty.setDomain(ontClass);
                ontProperty2.setDomain(ontClass);
                ontProperty4.setDomain(ontClass2);
                if (this.m_rdfsLang) {
                    this.iteratorTest(ontClass.listDeclaredProperties(), new Object[]{ontProperty, ontProperty2});
                } else {
                    Restriction restriction = ontModel.createRestriction(ontProperty3);
                    ontClass2.addSuperClass(restriction);
                    this.iteratorTest(ontClass.listDeclaredProperties(), new Object[]{ontProperty, ontProperty2});
                    this.iteratorTest(restriction.listDeclaredProperties(), new Object[]{ontProperty3});
                }
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties.notAll", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass2.addSuperClass(ontClass);
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                ontProperty.setDomain(ontClass);
                ontProperty2.setDomain(ontClass);
                ontProperty3.setDomain(ontClass2);
                this.iteratorTest(ontClass2.listDeclaredProperties(true), new Object[]{ontProperty, ontProperty2, ontProperty3});
                this.iteratorTest(ontClass2.listDeclaredProperties(false), new Object[]{ontProperty3});
                43.assertTrue((String)"declared property should be an ont prop", (boolean)(ontClass2.listDeclaredProperties(true).next() instanceof OntProperty));
                43.assertTrue((String)"declared property should be an ont prop", (boolean)(ontClass2.listDeclaredProperties(false).next() instanceof OntProperty));
            }
        }};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

