/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import junit.framework.TestSuite;

public class TestDAMLProperty
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLProperty("TestDAMLProperty");
    }

    public TestDAMLProperty(String string) {
        super(string);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLProperty.unique"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                1.assertFalse((String)"unique", (boolean)dAMLProperty.isUnique());
                dAMLProperty.setIsUnique(true);
                1.assertTrue((String)"unique", (boolean)dAMLProperty.isUnique());
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_domain"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals((String)"prop_domain property", (Object)DAML_OIL.domain, (Object)dAMLProperty.prop_domain().getProperty());
                2.assertEquals((String)"domain cardinality", (int)0, (int)dAMLProperty.prop_domain().count());
                dAMLProperty.prop_domain().add(dAMLClass);
                2.assertEquals((String)"domain cardinality", (int)1, (int)dAMLProperty.prop_domain().count());
                dAMLProperty.prop_domain().add(dAMLClass2);
                2.assertEquals((String)"domain cardinality", (int)2, (int)dAMLProperty.prop_domain().count());
                this.iteratorTest(dAMLProperty.prop_domain().getAll(), new Object[]{dAMLClass, dAMLClass2});
                dAMLProperty.prop_domain().remove(dAMLClass2);
                2.assertEquals((String)"domain cardinality", (int)1, (int)dAMLProperty.prop_domain().count());
                this.iteratorTest(dAMLProperty.prop_domain().getAll(), new Object[]{dAMLClass});
                2.assertTrue((String)"getDAMLValue instanceOf DAMLCommon", (boolean)(dAMLProperty.prop_domain().getDAMLValue() instanceof DAMLCommon));
                2.assertTrue((String)"hasValue", (boolean)dAMLProperty.prop_domain().hasValue(dAMLClass));
                2.assertTrue((String)"hasValue", (!dAMLProperty.prop_domain().hasValue(dAMLClass2) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_range"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals((String)"prop_range property", (Object)DAML_OIL.range, (Object)dAMLProperty.prop_range().getProperty());
                3.assertEquals((String)"range cardinality", (int)0, (int)dAMLProperty.prop_range().count());
                dAMLProperty.prop_range().add(dAMLClass);
                3.assertEquals((String)"range cardinality", (int)1, (int)dAMLProperty.prop_range().count());
                dAMLProperty.prop_range().add(dAMLClass2);
                3.assertEquals((String)"range cardinality", (int)2, (int)dAMLProperty.prop_range().count());
                this.iteratorTest(dAMLProperty.prop_range().getAll(), new Object[]{dAMLClass, dAMLClass2});
                dAMLProperty.prop_range().remove(dAMLClass2);
                3.assertEquals((String)"range cardinality", (int)1, (int)dAMLProperty.prop_range().count());
                this.iteratorTest(dAMLProperty.prop_range().getAll(), new Object[]{dAMLClass});
                3.assertTrue((String)"getDAMLValue instanceOf DAMLCommon", (boolean)(dAMLProperty.prop_range().getDAMLValue() instanceof DAMLCommon));
                3.assertTrue((String)"hasValue", (boolean)dAMLProperty.prop_range().hasValue(dAMLClass));
                3.assertTrue((String)"hasValue", (!dAMLProperty.prop_range().hasValue(dAMLClass2) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_subPropertyOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                4.assertEquals((String)"prop_subPropertyOf property", (Object)DAML_OIL.subPropertyOf, (Object)dAMLProperty.prop_subPropertyOf().getProperty());
                4.assertEquals((String)"subPropertyOf cardinality", (int)0, (int)dAMLProperty.prop_subPropertyOf().count());
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty2);
                4.assertEquals((String)"subPropertyOf cardinality", (int)1, (int)dAMLProperty.prop_subPropertyOf().count());
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty3);
                4.assertEquals((String)"subPropertyOf cardinality", (int)2, (int)dAMLProperty.prop_subPropertyOf().count());
                this.iteratorTest(dAMLProperty.prop_subPropertyOf().getAll(), new Object[]{dAMLProperty2, dAMLProperty3});
                dAMLProperty.prop_subPropertyOf().remove(dAMLProperty3);
                4.assertEquals((String)"subPropertyOf cardinality", (int)1, (int)dAMLProperty.prop_subPropertyOf().count());
                this.iteratorTest(dAMLProperty.prop_subPropertyOf().getAll(), new Object[]{dAMLProperty2});
                4.assertTrue((String)"getDAMLValue instanceOf DAMLCommon", (boolean)(dAMLProperty.prop_subPropertyOf().getDAMLValue() instanceof DAMLCommon));
                4.assertTrue((String)"hasValue", (boolean)dAMLProperty.prop_subPropertyOf().hasValue(dAMLProperty2));
                4.assertTrue((String)"hasValue", (!dAMLProperty.prop_subPropertyOf().hasValue(dAMLProperty3) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSubProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLProperty3.prop_subPropertyOf().add(dAMLProperty2);
                dAMLProperty2.prop_subPropertyOf().add(dAMLProperty);
                5.assertEquals((String)"subPropertyOf p", (Object)dAMLProperty2, (Object)dAMLProperty.getSubProperty());
                this.iteratorTest(dAMLProperty.getSubProperties(), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSubProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSubProperties(true), new Object[]{dAMLProperty2});
                dAMLProperty3.prop_subPropertyOf().add(dAMLProperty);
                this.iteratorTest(dAMLProperty.getSubProperties(), new Object[]{dAMLProperty2, dAMLProperty3});
                this.iteratorTest(dAMLProperty.getSubProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSubProperties(true), new Object[]{dAMLProperty2, dAMLProperty3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSuperProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty2);
                dAMLProperty2.prop_subPropertyOf().add(dAMLProperty3);
                6.assertEquals((String)"superPropertyOf p", (Object)dAMLProperty2, (Object)dAMLProperty.getSuperProperty());
                this.iteratorTest(dAMLProperty.getSuperProperties(), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSuperProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSuperProperties(true), new Object[]{dAMLProperty2});
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty3);
                this.iteratorTest(dAMLProperty.getSuperProperties(), new Object[]{dAMLProperty2, dAMLProperty3});
                this.iteratorTest(dAMLProperty.getSuperProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSuperProperties(true), new Object[]{dAMLProperty2, dAMLProperty3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSameProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLProperty.prop_samePropertyAs().add(dAMLProperty2);
                dAMLProperty2.prop_samePropertyAs().add(dAMLProperty3);
                this.iteratorTest(dAMLProperty.getSameProperties(), new Object[]{dAMLProperty2});
                dAMLProperty.prop_samePropertyAs().add(dAMLProperty3);
                this.iteratorTest(dAMLProperty.getSameProperties(), new Object[]{dAMLProperty2, dAMLProperty3});
            }
        }, new DAMLTestBase.OntTestCase("Datatype property"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
                8.assertNotNull((Object)dAMLDatatypeProperty);
            }
        }, new DAMLTestBase.OntTestCase("unambiguous property"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                9.assertFalse((String)"p not unambiguous", (boolean)dAMLObjectProperty.isUnambiguous());
                dAMLObjectProperty.setIsUnambiguous(true);
                9.assertTrue((String)"p not unambiguous", (boolean)dAMLObjectProperty.isUnambiguous());
                dAMLObjectProperty.setIsUnambiguous(false);
                9.assertFalse((String)"p not unambiguous", (boolean)dAMLObjectProperty.isUnambiguous());
            }
        }, new DAMLTestBase.OntTestCase("Transitive property"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                10.assertFalse((String)"p not Transitive", (boolean)dAMLObjectProperty.isTransitive());
                dAMLObjectProperty.setIsTransitive(true);
                10.assertTrue((String)"p not Transitive", (boolean)dAMLObjectProperty.isTransitive());
                dAMLObjectProperty.setIsTransitive(false);
                10.assertFalse((String)"p not Transitive", (boolean)dAMLObjectProperty.isTransitive());
            }
        }, new DAMLTestBase.OntTestCase("DAMLObjectProperty.prop_inverseOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty dAMLObjectProperty2 = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                dAMLObjectProperty.prop_inverseOf().add(dAMLObjectProperty2);
                11.assertEquals((String)"inverse", (Object)dAMLObjectProperty2, (Object)dAMLObjectProperty.prop_inverseOf().get());
            }
        }};
    }
}

