/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public abstract class DAMLTestBase
extends TestSuite {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public DAMLTestBase(String string) {
        super(string);
        OntTestCase[] ontTestCaseArray = this.getTests();
        for (int i = 0; i < ontTestCaseArray.length; ++i) {
            this.addTest((Test)ontTestCaseArray[i]);
        }
    }

    protected OntTestCase[] getTests() {
        return null;
    }

    protected abstract class OntTestCase
    extends TestCase {
        protected String m_langElement;

        public OntTestCase(String string) {
            super("DAML API test " + string);
            this.m_langElement = string;
        }

        public void runTest() throws Exception {
            boolean bl = false;
            DAMLModel dAMLModel = ModelFactory.createDAMLModel();
            try {
                this.doTest(dAMLModel);
            }
            catch (ProfileException profileException) {
                bl = true;
            }
            OntTestCase.assertTrue((String)("language element " + this.m_langElement + " was  expected in DAML model "), (!bl ? 1 : 0) != 0);
        }

        protected abstract void doTest(DAMLModel var1) throws Exception;

        protected void iteratorTest(Iterator iterator, Object[] objectArray) {
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!arrayList.contains(e)) {
                    logger.debug((Object)(this.getName() + " - Unexpected iterator result: " + e));
                }
                OntTestCase.assertTrue((String)("Value " + e + " was not expected as a result from this iterator "), (boolean)arrayList.contains(e));
                OntTestCase.assertTrue((String)("Value " + e + " was not removed from the list "), (boolean)arrayList.remove(e));
            }
            if (arrayList.size() != 0) {
                logger.debug((Object)(this.getName() + "Expected iterator results not found"));
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    logger.debug((Object)(this.getName() + " - missing: " + iterator2.next()));
                }
            }
            OntTestCase.assertEquals((String)"There were expected elements from the iterator that were not found", (int)0, (int)arrayList.size());
        }
    }
}

