/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml;

import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class PropertyIterator
implements Iterator {
    protected LinkedList m_nodeQueue = new LinkedList();
    protected Property m_pred = null;
    protected Property m_inverse = null;
    protected HashSet m_predEquivs = new HashSet();
    protected HashSet m_inverseEquivs = new HashSet();
    protected boolean m_transitive = false;
    protected WeakHashMap m_seen = new WeakHashMap();
    protected Resource m_root = null;
    protected List m_roots = null;
    protected Object m_defaultValue = null;
    protected boolean m_defaultValueSeen = false;
    protected boolean m_useEquivalence = true;
    protected Model m_model = null;

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2) {
        this(resource, property, property2, bl, bl2, true);
    }

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2, boolean bl3) {
        this.m_root = resource;
        this.m_pred = property;
        this.m_inverse = property2;
        this.m_transitive = bl;
        this.m_useEquivalence = bl3;
        this.setModel();
        this.cachePropertyEquivs();
        if (bl2) {
            this.enqueue(resource);
        } else {
            this.expandQueue(resource);
        }
    }

    public PropertyIterator(Iterator iterator, Property property, Property property2, boolean bl, boolean bl2) {
        this(iterator, property, property2, bl, bl2, true);
    }

    public PropertyIterator(Iterator iterator, Property property, Property property2, boolean bl, boolean bl2, boolean bl3) {
        this.m_roots = new ArrayList();
        this.m_pred = property;
        this.m_inverse = property2;
        this.m_transitive = bl;
        this.m_useEquivalence = bl3;
        this.setModel();
        this.cachePropertyEquivs();
        if (bl2) {
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (this.m_model == null && resource.getModel() != null) {
                    this.m_model = resource.getModel();
                }
                if (!(resource instanceof Resource)) continue;
                this.m_roots.add(resource);
                this.enqueue(resource);
            }
        } else {
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (this.m_model == null && resource.getModel() != null) {
                    this.m_model = resource.getModel();
                }
                if (!(resource instanceof Resource)) continue;
                this.m_roots.add(resource);
                this.expandQueue(resource);
            }
        }
    }

    public boolean hasNext() {
        return !this.m_nodeQueue.isEmpty() || this.hasDefaultValue() && !this.m_defaultValueSeen;
    }

    public Object next() {
        if (!this.m_nodeQueue.isEmpty()) {
            RDFNode rDFNode = (RDFNode)this.m_nodeQueue.removeFirst();
            if (this.hasDefaultValue() && this.m_defaultValue.equals(rDFNode)) {
                this.m_defaultValueSeen = true;
            }
            if (rDFNode instanceof Resource) {
                this.expandQueue((Resource)rDFNode);
            }
            return rDFNode;
        }
        if (this.hasDefaultValue() && !this.m_defaultValueSeen) {
            this.m_defaultValueSeen = true;
            return this.m_defaultValue;
        }
        throw new NoSuchElementException("Tried to access next() element from empty property iterator");
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a property iterator");
    }

    public void setDefaultValue(Object object) {
        this.m_defaultValue = object;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }

    private void enqueue(RDFNode rDFNode) {
        if (!this.m_seen.containsKey(rDFNode)) {
            this.m_seen.put(rDFNode, Boolean.TRUE);
            this.m_nodeQueue.addLast(rDFNode);
            if (this.getUseEquivalence() && rDFNode instanceof DAMLCommon) {
                ExtendedIterator extendedIterator = ((DAMLCommon)rDFNode).getEquivalentValues();
                while (extendedIterator.hasNext()) {
                    this.enqueue((RDFNode)extendedIterator.next());
                }
            }
        }
    }

    protected void expandQueue(Resource resource) {
        Iterator iterator;
        if (this.m_pred != null && (this.m_transitive || this.isRoot(resource))) {
            iterator = this.getStatementObjects(resource);
            while (iterator.hasNext()) {
                this.enqueue((RDFNode)iterator.next());
            }
        }
        if (this.m_inverse != null && (this.m_transitive || this.isRoot(resource))) {
            iterator = this.getStatementSubjects(resource);
            while (iterator.hasNext()) {
                this.enqueue((RDFNode)iterator.next());
            }
        }
    }

    protected boolean isRoot(Resource resource) {
        if (this.m_roots != null) {
            return this.m_roots.contains(resource);
        }
        return resource == this.m_root;
    }

    protected Iterator getStatementObjects(Resource resource) {
        Iterator iterator = null;
        if (this.getUseEquivalence() && resource instanceof DAMLCommon) {
            Iterator iterator2 = this.m_predEquivs.iterator();
            while (iterator2.hasNext()) {
                PropertyIterator propertyIterator = new PropertyIterator(resource, (Property)iterator2.next(), null, this.m_transitive, false, false);
                iterator = iterator == null ? propertyIterator : new ConcatenatedIterator(propertyIterator, iterator);
            }
        } else {
            iterator = this.m_model != null ? this.m_model.listObjectsOfProperty(resource, this.m_pred) : new LinkedList().iterator();
        }
        return iterator;
    }

    protected Iterator getStatementSubjects(Resource resource) {
        Iterator iterator = null;
        if (this.getUseEquivalence() && resource instanceof DAMLCommon) {
            Iterator iterator2 = this.m_inverseEquivs.iterator();
            while (iterator2.hasNext()) {
                PropertyIterator propertyIterator = new PropertyIterator(resource, null, (Property)iterator2.next(), this.m_transitive, false, false);
                iterator = iterator == null ? propertyIterator : new ConcatenatedIterator(propertyIterator, iterator);
            }
        } else {
            iterator = this.m_model != null ? this.m_model.listSubjectsWithProperty(this.m_inverse, resource) : new LinkedList().iterator();
        }
        return iterator;
    }

    protected void cachePropertyEquivs() {
        if (this.getUseEquivalence()) {
            ExtendedIterator extendedIterator;
            if (this.m_pred != null) {
                if (this.m_pred instanceof DAMLProperty) {
                    extendedIterator = ((DAMLProperty)this.m_pred).getEquivalentValues();
                    while (extendedIterator.hasNext()) {
                        this.cacheProperty(this.m_predEquivs, (Property)extendedIterator.next());
                    }
                } else {
                    this.cacheProperty(this.m_predEquivs, this.m_pred);
                }
            }
            if (this.m_inverse != null) {
                if (this.m_inverse instanceof DAMLProperty) {
                    extendedIterator = ((DAMLProperty)this.m_inverse).getEquivalentValues();
                    while (extendedIterator.hasNext()) {
                        this.cacheProperty(this.m_inverseEquivs, (Property)extendedIterator.next());
                    }
                } else {
                    this.cacheProperty(this.m_inverseEquivs, this.m_inverse);
                }
            }
        }
    }

    protected void cacheProperty(HashSet hashSet, Property property) {
        hashSet.add(property);
        if (property instanceof DAMLProperty && !property.getLocalName().equals(DAML_OIL.subPropertyOf.getLocalName())) {
            ExtendedIterator extendedIterator = ((DAMLProperty)property).getSubProperties();
            while (extendedIterator.hasNext()) {
                hashSet.add(extendedIterator.next());
            }
        }
    }

    protected void setModel() {
        if (this.m_root != null && this.m_root.getModel() != null) {
            this.m_model = this.m_root.getModel();
            return;
        }
        if (this.m_pred != null && this.m_pred.getModel() != null) {
            this.m_model = this.m_pred.getModel();
            return;
        }
        if (this.m_inverse != null && this.m_inverse.getModel() != null) {
            this.m_model = this.m_inverse.getModel();
            return;
        }
        if (this.m_roots != null) {
            Iterator iterator = this.m_roots.iterator();
            while (iterator.hasNext()) {
                RDFNode rDFNode = (RDFNode)iterator.next();
                if (!(rDFNode instanceof Resource) || ((Resource)rDFNode).getModel() == null) continue;
                this.m_model = ((Resource)rDFNode).getModel();
                return;
            }
        }
    }

    protected boolean getUseEquivalence() {
        return false;
    }
}

