/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;

public class OntModelSpec {
    public static final OntModelSpec OWL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/2002/07/owl#");
    public static final OntModelSpec OWL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.w3.org/2002/07/owl#");
    public static final OntModelSpec OWL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.w3.org/2002/07/owl#");
    public static final OntModelSpec OWL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), "http://www.w3.org/2002/07/owl#");
    public static final OntModelSpec OWL_DL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_DL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_DL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_DL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_LITE_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec OWL_LITE_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec OWL_LITE_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec OWL_LITE_MEM_RULES_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec DAML_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec RDFS_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    protected OntDocumentManager m_docManager = null;
    protected Reasoner m_reasoner = null;
    protected String m_languageURI;
    protected Profile m_profile = null;
    protected ModelMaker m_maker = null;
    protected ReasonerFactory m_rFactory = null;

    public OntModelSpec(ModelMaker modelMaker, OntDocumentManager ontDocumentManager, ReasonerFactory reasonerFactory, String string) {
        this.setDocumentManager(ontDocumentManager);
        this.setModelMaker(modelMaker);
        this.setReasonerFactory(reasonerFactory);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create OntModelSpec with a null ontology language");
        }
        this.setLanguage(string);
    }

    public OntModelSpec(OntModelSpec ontModelSpec) {
        this.setDocumentManager(ontModelSpec.getDocumentManager());
        this.setModelMaker(ontModelSpec.getModelMaker());
        this.setReasonerFactory(ontModelSpec.getReasonerFactory());
        this.setLanguage(ontModelSpec.getLanguage());
    }

    public static OntModelSpec getDefaultSpec(String string) {
        if (string.equals("http://www.w3.org/2002/07/owl#")) {
            return OWL_MEM_RDFS_INF;
        }
        if (string.equals("http://www.w3.org/TR/owl-features/#term_OWLDL")) {
            return OWL_DL_MEM_RDFS_INF;
        }
        if (string.equals("http://www.w3.org/TR/owl-features/#term_OWLLite")) {
            return OWL_LITE_MEM_RDFS_INF;
        }
        if (string.equals("http://www.daml.org/2001/03/daml+oil#")) {
            return DAML_MEM_RDFS_INF;
        }
        if (string.equals(ProfileRegistry.RDFS_LANG)) {
            return RDFS_MEM_RDFS_INF;
        }
        throw new OntologyException("Did not recognise this language URI, so cannot determine default model spec: " + string);
    }

    public OntDocumentManager getDocumentManager() {
        if (this.m_docManager == null) {
            this.m_docManager = new OntDocumentManager();
        }
        return this.m_docManager;
    }

    public void setDocumentManager(OntDocumentManager ontDocumentManager) {
        this.m_docManager = ontDocumentManager;
    }

    public ModelMaker getModelMaker() {
        if (this.m_maker == null) {
            this.m_maker = ModelFactory.createMemModelMaker();
        }
        return this.m_maker;
    }

    public void setModelMaker(ModelMaker modelMaker) {
        this.m_maker = modelMaker;
    }

    public Reasoner getReasoner() {
        if (this.m_reasoner == null && this.m_rFactory != null) {
            this.m_reasoner = this.m_rFactory.create(null);
        }
        return this.m_reasoner;
    }

    public void setReasoner(Reasoner reasoner) {
        this.m_reasoner = reasoner;
    }

    public void setReasonerFactory(ReasonerFactory reasonerFactory) {
        this.m_rFactory = reasonerFactory;
    }

    public ReasonerFactory getReasonerFactory() {
        return this.m_rFactory;
    }

    public String getLanguage() {
        return this.m_languageURI;
    }

    public void setLanguage(String string) {
        this.m_languageURI = string;
        this.m_profile = ProfileRegistry.getInstance().getProfile(this.m_languageURI);
        if (this.m_profile == null) {
            throw new OntologyException("Could not determine an ontology language profile for URI " + this.m_languageURI);
        }
    }

    public Profile getProfile() {
        return this.m_profile;
    }
}

