/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class OntDocumentManager {
    public static final String DEFAULT_METADATA_PATH = "file:etc/ont-policy.rdf;file:ont-policy.rdf";
    public static final String PATH_DELIMITER = ";";
    public static final String NS = "http://jena.hpl.hp.com/schemas/2003/03/ont-manager#";
    private static final Model vocab = ModelFactory.createDefaultModel();
    public static final Resource ONTOLOGY_SPEC = vocab.createResource("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#OntologySpec");
    public static final Property PUBLIC_URI = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#publicURI");
    public static final Property ALT_URL = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#altURL");
    public static final Property PREFIX = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#prefix");
    public static final Property LANGUAGE = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#language");
    public static final Resource DOC_MGR_POLICY = vocab.createResource("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#DocumentManagerPolicy");
    public static final Property CACHE_MODELS = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#", "cacheModels");
    public static final Property PROCESS_IMPORTS = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#", "processImports");
    public static final Property IGNORE_IMPORT = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#", "ignoreImport");
    public static final Property USE_DECLARED_NS_PREFIXES = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#", "useDeclaredNsPrefixes");
    private static OntDocumentManager s_instance = new OntDocumentManager();
    protected String m_searchPath = "file:etc/ont-policy.rdf;file:ont-policy.rdf";
    protected Map m_altMap = new HashMap();
    protected Map m_modelMap = new HashMap();
    protected Map m_languageMap = new HashMap();
    private Logger m_log = Logger.getLogger(this.getClass());
    protected boolean m_cacheModels = true;
    protected boolean m_processImports = true;
    protected Set m_ignoreImports = new HashSet();
    protected PrefixMapping m_prefixMap = new PrefixMappingImpl();
    protected boolean m_useDeclaredPrefixes = true;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntDocumentManager;

    public OntDocumentManager() {
        this(DEFAULT_METADATA_PATH);
    }

    public OntDocumentManager(String string) {
        this.m_searchPath = string == null ? "" : string;
        this.initialiseMetadata(this.m_searchPath, false);
    }

    public static OntDocumentManager getInstance() {
        return s_instance;
    }

    public String getMetadataSearchPath() {
        return this.m_searchPath;
    }

    public void setMetadataSearchPath(String string, boolean bl) {
        this.m_searchPath = string;
        this.initialiseMetadata(string, bl);
    }

    public Iterator listDocuments() {
        return this.m_altMap.keySet().iterator();
    }

    public String doAltURLMapping(String string) {
        String string2 = (String)this.m_altMap.get(string);
        return string2 == null ? string : string2;
    }

    public String getLanguage(String string) {
        return (String)this.m_languageMap.get(string);
    }

    public String getPrefixForURI(String string) {
        return this.m_prefixMap.usePrefix(string);
    }

    public String getURIForPrefix(String string) {
        return this.m_prefixMap.getNsPrefixURI(string);
    }

    public Model getModel(String string) {
        return (Model)this.m_modelMap.get(string);
    }

    public boolean useDeclaredPrefixes() {
        return this.m_useDeclaredPrefixes;
    }

    public void setUseDeclaredPrefixes(boolean bl) {
        this.m_useDeclaredPrefixes = bl;
    }

    public PrefixMapping getDeclaredPrefixMapping() {
        return this.m_prefixMap;
    }

    public void addPrefixMapping(String string, String string2) {
        this.m_prefixMap.setNsPrefix(string2, string);
    }

    public void addAltEntry(String string, String string2) {
        this.m_altMap.put(string, string2);
    }

    public void addModel(String string, Model model) {
        if (this.m_cacheModels) {
            this.m_modelMap.put(string, model);
        }
    }

    public void addLanguageEntry(String string, String string2) {
        this.m_languageMap.put(string, string2);
    }

    public void forget(String string) {
        this.m_altMap.remove(string);
        this.m_modelMap.remove(string);
        this.m_languageMap.remove(string);
    }

    public Model getOntology(String string, OntModelSpec ontModelSpec) {
        if (this.m_modelMap.containsKey(string)) {
            return (Model)this.m_modelMap.get(string);
        }
        OntModelSpec ontModelSpec2 = ontModelSpec;
        if (ontModelSpec2.getDocumentManager() != this) {
            ontModelSpec2 = new OntModelSpec(ontModelSpec);
            ontModelSpec2.setDocumentManager(this);
        }
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        this.read(ontModel, string, true);
        return ontModel;
    }

    public boolean getProcessImports() {
        return this.m_processImports;
    }

    public boolean getCacheModels() {
        return this.m_cacheModels;
    }

    public void setProcessImports(boolean bl) {
        this.m_processImports = bl;
    }

    public void setCacheModels(boolean bl) {
        this.m_cacheModels = bl;
    }

    public void addIgnoreImport(String string) {
        this.m_ignoreImports.add(string);
    }

    public void removeIgnoreImport(String string) {
        this.m_ignoreImports.remove(string);
    }

    public Iterator listIgnoredImports() {
        return this.m_ignoreImports.iterator();
    }

    public boolean ignoringImport(String string) {
        return this.m_ignoreImports.contains(string);
    }

    public void clearCache() {
        this.m_modelMap.clear();
    }

    public void loadImports(OntModel ontModel) {
        if (this.m_processImports) {
            ArrayList arrayList = new ArrayList();
            this.queueImports(ontModel, arrayList, ontModel.getProfile());
            while (!arrayList.isEmpty()) {
                String string = (String)arrayList.remove(0);
                if (ontModel.hasLoadedImport(string) || this.ignoringImport(string)) continue;
                this.loadImport(ontModel, string, arrayList);
            }
        }
    }

    protected void queueImports(Model model, List list, Profile profile) {
        if (model instanceof OntModel) {
            list.addAll(((OntModel)model).listImportedOntologyURIs());
        } else {
            StmtIterator stmtIterator = model.listStatements(null, profile.IMPORTS(), (RDFNode)null);
            while (stmtIterator.hasNext()) {
                Resource resource = stmtIterator.nextStatement().getResource();
                list.add(resource.getURI());
            }
            stmtIterator.close();
        }
    }

    protected void initialiseMetadata(String string, boolean bl) {
        if (bl) {
            this.m_altMap.clear();
            this.m_modelMap.clear();
            this.m_prefixMap = new PrefixMappingImpl();
        }
        this.m_prefixMap.setNsPrefixes(PrefixMapping.Standard);
        Model model = this.findMetadata(string);
        if (model != null) {
            this.loadMetadata(model);
        }
    }

    protected Model findMetadata(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_DELIMITER);
        Model model = ModelFactory.createDefaultModel();
        boolean bl = false;
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            bl = this.read(model, string2, false);
        }
        return bl ? model : null;
    }

    protected void loadMetadata(Model model) {
        Object object;
        Object object2;
        Resource resource;
        ResIterator resIterator = model.listSubjectsWithProperty(RDF.type, DOC_MGR_POLICY);
        while (resIterator.hasNext()) {
            resource = resIterator.nextResource();
            object2 = resource.listProperties();
            while (object2.hasNext()) {
                object = object2.nextStatement();
                Property property = object.getPredicate();
                if (property.equals(CACHE_MODELS)) {
                    this.setCacheModels(object.getBoolean());
                    continue;
                }
                if (property.equals(PROCESS_IMPORTS)) {
                    this.setProcessImports(object.getBoolean());
                    continue;
                }
                if (property.equals(IGNORE_IMPORT)) {
                    this.addIgnoreImport(object.getResource().getURI());
                    continue;
                }
                if (!property.equals(USE_DECLARED_NS_PREFIXES)) continue;
                this.setUseDeclaredPrefixes(object.getBoolean());
            }
        }
        resIterator = model.listSubjectsWithProperty(RDF.type, ONTOLOGY_SPEC);
        while (resIterator.hasNext()) {
            resource = resIterator.nextResource();
            object2 = resource.getProperty(PUBLIC_URI);
            if (object2 != null) {
                object = object2.getResource().getURI();
                try {
                    object2 = resource.getProperty(ALT_URL);
                    this.addAltEntry((String)object, object2.getResource().getURI());
                }
                catch (JenaException jenaException) {
                    // empty catch block
                }
                try {
                    object2 = resource.getProperty(PREFIX);
                    this.addPrefixMapping((String)object, object2.getString());
                }
                catch (JenaException jenaException) {
                    // empty catch block
                }
                try {
                    object2 = resource.getProperty(LANGUAGE);
                    this.addLanguageEntry((String)object, object2.getResource().getURI());
                }
                catch (JenaException jenaException) {}
                continue;
            }
            this.m_log.warn((Object)"Ontology specification node lists no public URI - node ignored");
        }
    }

    protected void loadImport(OntModel ontModel, String string, List list) {
        Logger.getLogger(this.getClass()).debug((Object)("OntDocumentManager loading " + string));
        ontModel.addLoadedImport(string);
        Model model = this.getModel(string);
        if (model == null) {
            ModelMaker modelMaker = ontModel.getSpecification().getModelMaker();
            boolean bl = modelMaker.hasModel(string);
            model = modelMaker.openModel(string);
            if (!bl) {
                this.read(model, string, true);
            }
        }
        this.queueImports(model, list, ontModel.getProfile());
        ontModel.addSubModel(model, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean read(Model model, String string, boolean bl) {
        String string2 = this.doAltURLMapping(string);
        String string3 = string2.startsWith("file:") ? string2.substring(5) : string2;
        try {
            String string4 = ModelLoader.guessLang(string);
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string3);
            if (inputStream == null) {
                model.read(string2, string4);
            } else {
                try {
                    model.read(inputStream, string, string4);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.addModel(string, model);
            return true;
        }
        catch (JenaException jenaException) {
            if (bl) {
                Logger.getLogger((Class)(class$com$hp$hpl$jena$ontology$OntDocumentManager == null ? (class$com$hp$hpl$jena$ontology$OntDocumentManager = OntDocumentManager.class$("com.hp.hpl.jena.ontology.OntDocumentManager")) : class$com$hp$hpl$jena$ontology$OntDocumentManager)).warn((Object)("JenaException while reading model from " + string2 + ", with message: " + jenaException.getMessage()), (Throwable)jenaException);
            }
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

