/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.AntlrUtils;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Exception;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;

public class N3toRDF
implements N3ParserEventHandler {
    public static boolean VERBOSE = false;
    Model model;
    Map resourceRef = new HashMap();
    Map propertyRef = new HashMap();
    static final String NS_rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String NS_rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    static final String XMLLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    String base = null;
    final String anonPrefix = "_";
    private Map bNodeMap = new HashMap();

    public N3toRDF(Model model, String string) {
        this.model = model;
        this.base = string;
        if (VERBOSE) {
            System.out.println("N3toRDF: " + this.base);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void error(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void error(String string) {
        this.error(null, string);
    }

    public void warning(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void warning(String string) {
        this.warning(null, string);
    }

    public void deprecated(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void deprecated(String string) {
        this.deprecated(null, string);
    }

    public void startFormula(int n, String string) {
        this.error("Line " + n + ": N3toRDF: All statements are asserted - no formulae in RDF");
    }

    public void endFormula(int n, String string) {
    }

    public void directive(int n, AST aST, AST[] aSTArray, String string) {
        if (aST.getType() == 18) {
            if (aSTArray[0].getType() != 6) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not start with a prefix! " + aSTArray[0].getText() + "[" + N3Parser.getTokenNames()[aSTArray[0].getType()] + "]");
                return;
            }
            String string2 = aSTArray[0].getText();
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (aSTArray[1].getType() != 39) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not supply a URIref! " + aSTArray[1].getText());
                return;
            }
            String string3 = aSTArray[1].getText();
            if (string3.equals("")) {
                string3 = this.base;
            }
            if (string3.equals("#")) {
                string3 = this.base + "#";
            }
            if (VERBOSE) {
                System.out.println(string2 + " => " + string3);
            }
            this.model.setNsPrefix(string2, string3);
            return;
        }
        this.warning("Line " + n + ": N3toRDF: Directive not recongized and ignored: " + aST.getText());
    }

    public void quad(int n, AST aST, AST aST2, AST aST3, String string) {
        if (string != null) {
            this.error("Line " + n + ": N3toRDF: All statement are asserted - no formulae");
        }
        try {
            Object object;
            Object object2;
            int n2 = aST2.getType();
            String string2 = aST2.getText();
            Property property = null;
            switch (n2) {
                case 28: {
                    string2 = "http://www.w3.org/2000/10/swap/log#implies";
                    break;
                }
                case 48: {
                    string2 = "http://www.w3.org/2000/10/swap/log#means";
                    break;
                }
                case 29: {
                    string2 = "http://www.w3.org/2000/10/swap/log#implies";
                    object2 = aST3;
                    aST3 = aST;
                    aST = object2;
                    break;
                }
                case 27: {
                    property = OWL.sameAs;
                    break;
                }
                case 12: {
                    property = RDF.type;
                    break;
                }
                case 6: {
                    object = this.model.expandPrefix(string2);
                    if (object == string2) {
                        this.error("Line " + n + ": N3toRDF: Undefined qname namespace: " + string2);
                        return;
                    }
                    property = this.model.createProperty((String)object);
                    break;
                }
                case 39: {
                    break;
                }
                case 15: {
                    property = RDF.first;
                    break;
                }
                case 16: {
                    property = RDF.rest;
                    break;
                }
                default: {
                    this.error("Line " + n + ": N3toRDF: Shouldn't see " + N3EventPrinter.formatSlot(aST2) + " at this point!");
                }
            }
            if (property == null) {
                property = this.model.createProperty(string2);
            } else {
                string2 = property.getURI();
            }
            object2 = this.createNode(n, aST);
            if (object2 instanceof Literal) {
                this.error("Line " + n + ": N3toRDF: Subject can't be a literal");
            }
            object = this.createNode(n, aST3);
            Statement statement = this.model.createStatement((Resource)object2, property, (RDFNode)object);
            if (VERBOSE) {
                System.out.println("Statement: " + statement);
            }
            this.model.add(statement);
        }
        catch (JenaException jenaException) {
            this.error("Line " + n + ": JenaException: " + jenaException);
        }
    }

    private RDFNode createNode(int n, AST aST) {
        String string = aST.getText();
        switch (aST.getType()) {
            case 21: {
                AST aST2 = aST.getNextSibling();
                AST aST3 = aST2 == null ? null : aST2.getNextSibling();
                AST aST4 = null;
                AST aST5 = null;
                if (aST3 != null) {
                    if (aST3.getType() == 38) {
                        aST4 = aST3.getFirstChild();
                    } else {
                        aST5 = aST3;
                    }
                }
                if (aST2 != null) {
                    if (aST2.getType() == 38) {
                        aST4 = aST2.getFirstChild();
                    } else {
                        aST5 = aST2;
                    }
                }
                String string2 = aST5 != null ? aST5.getText().substring(1) : null;
                String string3 = null;
                if (aST4 != null) {
                    string3 = aST4.getText();
                    switch (aST4.getType()) {
                        case 6: {
                            if (string3.startsWith("_:") || string3.startsWith("=:")) {
                                this.error("Line " + n + ": N3toRDF: Use bNode for datatype URI: " + string + "^^" + string3);
                                return this.model.createLiteral("Illegal literal: " + string + "^^" + string3);
                            }
                            String string4 = this.model.expandPrefix(string3);
                            if (string4 == string3) {
                                this.error("Line " + n + ": N3toRDF: Undefined qname namespace in datatype: " + string3);
                            }
                            string3 = string4;
                        }
                        case 39: {
                            string3 = this.expandHereURIRef(string3);
                            break;
                        }
                        default: {
                            this.error("Line " + n + ": N3toRDF: Must use URIref or QName datatype URI: " + string + "^^" + string3 + "(" + N3Parser.getTokenNames()[aST4.getType()] + ")");
                            return this.model.createLiteral("Illegal literal: " + string + "^^" + string3);
                        }
                    }
                }
                return this.model.createTypedLiteral(string, string2, string3);
            }
            case 6: {
                if (string.startsWith("_:") && this.model.getNsPrefixURI("_") == null) {
                    if (!this.bNodeMap.containsKey(string)) {
                        this.bNodeMap.put(string, this.model.createResource());
                    }
                    return (Resource)this.bNodeMap.get(string);
                }
                String string5 = this.model.expandPrefix(string);
                if (string5 == string) {
                    this.error("Line " + n + ": N3toRDF: Undefined qname namespace: " + string);
                    return null;
                }
                return this.model.createResource(this.expandHereURIRef(string5));
            }
            case 39: {
                return this.model.createResource(this.expandHereURIRef(string));
            }
            case 17: {
                return RDF.nil;
            }
            case 14: {
                return RDF.List;
            }
            case 4: {
                if (!this.bNodeMap.containsKey(string)) {
                    this.bNodeMap.put(string, this.model.createResource());
                }
                return (Resource)this.bNodeMap.get(string);
            }
            case 40: {
                this.error("Line " + n + ": N3toRDF: Can't map variables to RDF: " + string);
                break;
            }
            default: {
                this.error("Line " + n + ": N3toRDF: Can't map to a resource or literal: " + AntlrUtils.ast(aST));
            }
        }
        return null;
    }

    private String expandHereURIRef(String string) {
        if (string.equals("")) {
            return this.base;
        }
        if (string.equals("#")) {
            return this.base + "#";
        }
        return string;
    }
}

