/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.ConstraintStage;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Query {
    public static final String anon = "<this>";
    public static final Node ANY = Node.ANY;
    public static final Node S = Node.createVariable("S");
    public static final Node P = Node.createVariable("P");
    public static final Node O = Node.createVariable("O");
    public static final Node X = Node.createVariable("X");
    public static final Node Y = Node.createVariable("Y");
    public static final Node Z = Node.createVariable("Z");
    public static final Node NE = GraphTestBase.node("&ne");
    private HashMap triples = new HashMap();
    private Graph constraintGraph = new GraphMem();
    private ArgMap argMap = new ArgMap();
    private int variableCount = -1;

    public Query() {
    }

    public Query(Graph graph) {
        this.addMatches(graph);
    }

    public Query addMatch(Node node, Node node2, Node node3) {
        return this.addNamedMatch(anon, node, node2, node3);
    }

    public Query addMatch(Triple triple) {
        return this.addNamedMatch(anon, triple);
    }

    public Query addMatch(String string, Node node, Node node2, Node node3) {
        return this.addNamedMatch(string, node, node2, node3);
    }

    public Query addConstraint(Node node, Node node2, Node node3) {
        this.constraintGraph.add(new Triple(node, node2, node3));
        return this;
    }

    public Query addConstraint(Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            this.constraintGraph.add((Triple)extendedIterator.next());
        }
        return this;
    }

    private void addMatches(Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            this.addMatch((Triple)extendedIterator.next());
        }
    }

    public ExtendedIterator executeBindings(Graph graph, Node[] nodeArray) {
        return this.executeBindings(this.args().put(anon, graph), nodeArray);
    }

    public ExtendedIterator executeBindings(ArgMap argMap, Node[] nodeArray) {
        BufferPipe bufferPipe = new BufferPipe();
        Mapping mapping = new Mapping();
        ArrayList<ConstraintStage> arrayList = new ArrayList<ConstraintStage>();
        this.addStages(arrayList, argMap, mapping);
        arrayList.add(new ConstraintStage(mapping, this.constraintGraph));
        int[] nArray = this.findIndexes(mapping, nodeArray);
        this.variableCount = mapping.size();
        return this.filter(nArray, this.connectStages(arrayList, this.variableCount).deliver(bufferPipe));
    }

    private int[] findIndexes(Mapping mapping, Node[] nodeArray) {
        int[] nArray = new int[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nArray[i] = this.findIndex(mapping, nodeArray[i]);
        }
        return nArray;
    }

    private int findIndex(Mapping mapping, Node node) {
        if (!mapping.maps(node)) {
            mapping.newIndex(node);
        }
        return mapping.indexOf(node);
    }

    private ExtendedIterator filter(final int[] nArray, final Pipe pipe) {
        return new NiceIterator(){

            public Object next() {
                return Query.this.filter(nArray, pipe.get());
            }

            public boolean hasNext() {
                return pipe.hasNext();
            }
        };
    }

    private Domain filter(int[] nArray, Domain domain) {
        Domain domain2 = new Domain(new Object[nArray.length]);
        for (int i = 0; i < nArray.length; ++i) {
            domain2.setElement(i, domain.get(nArray[i]));
        }
        return domain2;
    }

    public ArgMap args() {
        return this.argMap;
    }

    private Query addNamedMatch(String string, Node node, Node node2, Node node3) {
        return this.addNamedMatch(string, new Triple(node, node2, node3));
    }

    private Query addNamedMatch(String string, Triple triple) {
        this.triples.put(string, new Cons(triple, (Cons)this.triples.get(string)));
        return this;
    }

    private void addStages(ArrayList arrayList, ArgMap argMap, Mapping mapping) {
        Iterator iterator = this.triples.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Cons cons = (Cons)entry.getValue();
            Graph graph = argMap.get(string);
            int n2 = n = Cons.size(cons);
            Triple[] tripleArray = new Triple[n];
            while (cons != null) {
                tripleArray[--n2] = cons.head;
                cons = cons.tail;
            }
            Stage stage = graph.queryHandler().patternStage(mapping, this.constraintGraph, tripleArray);
            arrayList.add(stage);
        }
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    private Stage connectStages(ArrayList arrayList, int n) {
        Stage stage = Stage.initial(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            stage = ((Stage)arrayList.get(i)).connectFrom(stage);
        }
        return stage;
    }

    private static class Cons {
        Triple head;
        Cons tail;

        Cons(Triple triple, Cons cons) {
            this.head = triple;
            this.tail = cons;
        }

        static int size(Cons cons) {
            int n = 0;
            while (cons != null) {
                ++n;
                cons = cons.tail;
            }
            return n;
        }
    }

    public static class ArgMap {
        private HashMap map = new HashMap();

        ArgMap() {
        }

        public ArgMap put(String string, Graph graph) {
            this.map.put(string, graph);
            return this;
        }

        public Graph get(String string) {
            return (Graph)this.map.get(string);
        }
    }
}

