/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pattern;
import com.hp.hpl.jena.graph.query.PatternCompiler;
import com.hp.hpl.jena.graph.query.PatternStageCompiler;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class PatternStage
extends Stage {
    protected Graph graph;
    protected Pattern[] compiled;
    private static final PatternCompiler compiler = new PatternStageCompiler();

    public PatternStage(Graph graph, Mapping mapping, Triple[] tripleArray) {
        this.graph = graph;
        this.compiled = this.compile(mapping, tripleArray);
    }

    protected Pattern[] compile(Mapping mapping, Triple[] tripleArray) {
        return this.compile(compiler, mapping, tripleArray);
    }

    protected Pattern[] compile(PatternCompiler patternCompiler, Mapping mapping, Triple[] tripleArray) {
        return PatternStageCompiler.compile(patternCompiler, mapping, tripleArray);
    }

    protected void run(Pipe pipe, Pipe pipe2) {
        while (pipe.hasNext()) {
            Domain domain = pipe.get();
            Domain domain2 = domain.extend();
            ExtendedIterator extendedIterator = this.graph.find(this.compiled[0].asTripleMatch(domain));
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                if (!this.compiled[0].matches(domain2, triple)) continue;
                pipe2.put(this.compiled[0].matched(domain2, triple));
                domain2 = domain.extend();
            }
        }
        pipe2.close();
    }

    public Pipe deliver(final Pipe pipe) {
        final Pipe pipe2 = this.previous.deliver(new BufferPipe());
        new Thread(){

            public void run() {
                PatternStage.this.run(pipe2, pipe);
            }
        }.start();
        return pipe;
    }
}

