/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Element;

public class Pattern {
    private Element S;
    private Element P;
    private Element O;

    public Pattern(Element element, Element element2, Element element3) {
        this.S = element;
        this.P = element2;
        this.O = element3;
    }

    public TripleMatch asTripleMatch(Domain domain) {
        return Triple.createMatch(this.S.asNode(domain), this.P.asNode(domain), this.O.asNode(domain));
    }

    public Element[] getParts() {
        return new Element[]{this.S, this.P, this.O};
    }

    public boolean matches(Domain domain, Triple triple) {
        return this.S.accepts(domain, triple.getSubject()) && this.P.accepts(domain, triple.getPredicate()) && this.O.accepts(domain, triple.getObject());
    }

    public Domain matched(Domain domain, Triple triple) {
        this.S.matched(domain, triple.getSubject());
        this.P.matched(domain, triple.getPredicate());
        this.O.matched(domain, triple.getObject());
        return domain;
    }

    public String toString() {
        return "<pattern " + this.S + " @" + this.P + " " + this.O + ">";
    }
}

