/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Predicate;
import com.hp.hpl.jena.graph.query.PredicateFactory;
import com.hp.hpl.jena.graph.query.Relation_EQ;
import com.hp.hpl.jena.graph.query.Relation_NE;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.ValuatorConst;
import com.hp.hpl.jena.graph.query.ValuatorVariable;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;

public class ConstraintStage
extends Stage {
    private Predicate predicate;
    private static HashMap factories = new HashMap();
    static final PredicateFactory makeEQ = new PredicateFactory(){

        public Predicate construct(Valuator valuator, Valuator valuator2) {
            return new Relation_EQ(valuator, valuator2);
        }
    };
    static final PredicateFactory makeNE = new PredicateFactory(){

        public Predicate construct(Valuator valuator, Valuator valuator2) {
            return new Relation_NE(valuator, valuator2);
        }
    };

    public ConstraintStage(Mapping mapping, Graph graph) {
        this.predicate = this.translate(mapping, graph);
    }

    private Predicate translate(Mapping mapping, Graph graph) {
        Predicate predicate = Predicate.TRUE;
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            predicate = predicate.and(this.translate(mapping, (Triple)extendedIterator.next()));
        }
        return predicate;
    }

    private Predicate translate(Mapping mapping, Triple triple) {
        Node node = triple.getPredicate();
        Valuator valuator = this.translate(mapping, triple.getSubject());
        Valuator valuator2 = this.translate(mapping, triple.getObject());
        PredicateFactory predicateFactory = (PredicateFactory)factories.get(node);
        if (predicateFactory == null) {
            throw new UnsupportedOperationException(node.toString());
        }
        return predicateFactory.construct(valuator, valuator2);
    }

    private Valuator translate(Mapping mapping, Node node) {
        return node.isVariable() ? new ValuatorVariable(mapping.indexOf(node)) : new ValuatorConst(node);
    }

    public static void addFactory(String string, PredicateFactory predicateFactory) {
        Node node = Node.createURI(string);
        if (factories.containsKey(node)) {
            throw new UnsupportedOperationException("cannot redefine: " + predicateFactory);
        }
        factories.put(node, predicateFactory);
    }

    public Pipe deliver(final Pipe pipe) {
        final Pipe pipe2 = this.previous.deliver(new BufferPipe());
        new Thread("a ConstraintStage"){

            public void run() {
                while (pipe2.hasNext()) {
                    Domain domain = pipe2.get();
                    if (!ConstraintStage.this.predicate.evaluateBool(domain)) continue;
                    pipe.put(domain);
                }
                pipe.close();
            }
        }.start();
        return pipe;
    }

    static {
        ConstraintStage.addFactory("q:eq", makeEQ);
        ConstraintStage.addFactory("q:ne", makeNE);
    }
}

