/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.JenaAddDeniedException;
import com.hp.hpl.jena.shared.JenaDeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public interface Graph {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int SIZE = 4;
    public static final int ORDERED = 8;

    public boolean dependsOn(Graph var1);

    public QueryHandler queryHandler();

    public TransactionHandler getTransactionHandler();

    public BulkUpdateHandler getBulkUpdateHandler();

    public Capabilities getCapabilities();

    public GraphEventManager getEventManager();

    public Reifier getReifier();

    public PrefixMapping getPrefixMapping();

    public void add(Triple var1) throws JenaAddDeniedException;

    public void delete(Triple var1) throws JenaDeleteDeniedException;

    public ExtendedIterator find(TripleMatch var1);

    public ExtendedIterator find(Node var1, Node var2, Node var3);

    public boolean isIsomorphicWith(Graph var1);

    public boolean contains(Node var1, Node var2, Node var3);

    public boolean contains(Triple var1);

    public void close();

    public int size() throws UnsupportedOperationException;

    public int capabilities();
}

