/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.JenaException;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestReifier
extends GraphTestBase {
    private ArrayList theGraphs = new ArrayList();
    private IDBConnection theConnection;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestReifier;

    public TestReifier(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestReifier == null ? (class$com$hp$hpl$jena$db$test$TestReifier = TestReifier.class$("com.hp.hpl.jena.db.test.TestReifier")) : class$com$hp$hpl$jena$db$test$TestReifier);
    }

    public void setUp() {
        this.theConnection = TestConnection.makeAndCleanTestConnection();
    }

    public void tearDown() {
        try {
            this.theConnection.cleanDB();
            this.theGraphs.clear();
            this.theConnection.close();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public Graph getGraph() {
        GraphRDB graphRDB = new GraphRDB(this.theConnection, "name" + this.theGraphs.size(), this.theConnection.getDefaultModelProperties().getGraph(), 2, true);
        this.theGraphs.add(graphRDB);
        return graphRDB;
    }

    public void testEmptyReifiers() {
        TestReifier.assertEquals((String)"no reified triples", (int)0, (int)TestReifier.graphWith("x R y").getReifier().getHiddenTriples().size());
        TestReifier.assertEquals((String)"no reified triples", (int)0, (int)TestReifier.graphWith("x R y; p S q").getReifier().getHiddenTriples().size());
    }

    public void testSameReifier() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        graph.add(TestReifier.triple("x R y"));
        TestReifier.assertTrue((String)"same reifier", (reifier == graph.getReifier() ? 1 : 0) != 0);
    }

    public void testParent() {
        Graph graph = this.getGraph();
        Graph graph2 = this.getGraph();
        TestReifier.assertTrue((String)"correct reifier (G)", (graph == graph.getReifier().getParentGraph() ? 1 : 0) != 0);
        TestReifier.assertTrue((String)"correct reifier (H)", (graph2 == graph2.getReifier().getParentGraph() ? 1 : 0) != 0);
    }

    public void testIntercept() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = TestReifier.node("sub");
        Node node2 = TestReifier.node("obj");
        Node node3 = TestReifier.node("http://example.org/type");
        TestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, Reifier.type, node3)));
        TestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, node, Reifier.subject)));
        TestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, node, Reifier.type)));
        TestReifier.assertTrue((String)"reifier must intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, Reifier.predicate, node2)));
        TestReifier.assertTrue((String)"reifier must intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, Reifier.type, Reifier.Statement)));
    }

    public void testHiddenTriples() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = TestReifier.node("SSS");
        Node node2 = TestReifier.node("PPP");
        Node node3 = TestReifier.node("OOO ");
        graph.add(new Triple(node, Reifier.predicate, node2));
        TestReifier.assertEquals((String)"graph must still be empty", (int)0, (int)graph.size());
        TestReifier.assertEquals((String)"reifier must have the triple", (int)1, (int)reifier.getHiddenTriples().size());
        TestReifier.assertContains("xxx", "SSS rdf:predicate PPP", reifier.getHiddenTriples());
        graph.add(new Triple(node, Reifier.subject, node));
        TestReifier.assertContains("xxx", "SSS rdf:subject SSS", reifier.getHiddenTriples());
    }

    public void testRetrieveTriplesByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createAnon();
        Node node2 = Node.createAnon();
        reifier.reifyAs(node, TestReifier.triple("x R y"));
        TestReifier.assertEquals((String)"gets correct triple", (Object)TestReifier.triple("x R y"), (Object)reifier.getTriple(node));
        reifier.reifyAs(node2, TestReifier.triple("p S q"));
        this.assertDiffer("the anon nodes must be distinct", node, node2);
        TestReifier.assertEquals((String)"gets correct triple", (Object)TestReifier.triple("p S q"), (Object)reifier.getTriple(node2));
        TestReifier.assertTrue((String)"node is known bound", (boolean)reifier.hasTriple(node2));
        TestReifier.assertTrue((String)"node is known bound", (boolean)reifier.hasTriple(node));
        TestReifier.assertFalse((String)"node is known unbound", (boolean)reifier.hasTriple(Node.createURI("any:thing")));
    }

    public void testRetrieveTriplesByTriple() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Triple triple = TestReifier.triple("x R y");
        Triple triple2 = TestReifier.triple("y R x");
        Node node = TestReifier.node("someNode");
        reifier.reifyAs(node, triple);
        TestReifier.assertTrue((String)"R must have T", (boolean)reifier.hasTriple(triple));
        TestReifier.assertFalse((String)"R must not have T2", (boolean)reifier.hasTriple(triple2));
    }

    public void testReifyAs() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createURI("some:uri");
        TestReifier.assertEquals((String)"node used", (Object)node, (Object)reifier.reifyAs(node, TestReifier.triple("x R y")));
        TestReifier.assertEquals((String)"retrieves correctly", (Object)TestReifier.triple("x R y"), (Object)reifier.getTriple(node));
    }

    public void testAllNodes() {
        Reifier reifier = this.getGraph().getReifier();
        reifier.reifyAs(TestReifier.node("x"), TestReifier.triple("cows eat grass"));
        reifier.reifyAs(TestReifier.node("y"), TestReifier.triple("pigs can fly"));
        reifier.reifyAs(TestReifier.node("z"), TestReifier.triple("dogs may bark"));
        TestReifier.assertEquals((String)"", (Object)this.nodeSet("z y x"), (Object)TestReifier.iteratorToSet(reifier.allNodes()));
    }

    public void testRemoveByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = TestReifier.node("x");
        Node node2 = TestReifier.node("y");
        reifier.reifyAs(node, TestReifier.triple("x R a"));
        reifier.reifyAs(node2, TestReifier.triple("y R a"));
        reifier.remove(node, TestReifier.triple("x R a"));
        TestReifier.assertFalse((String)"triple X has gone", (boolean)reifier.hasTriple(node));
        TestReifier.assertEquals((String)"triple Y still there", (Object)TestReifier.triple("y R a"), (Object)reifier.getTriple(node2));
    }

    public void testException() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = TestReifier.node("x");
        reifier.reifyAs(node, TestReifier.triple("x R y"));
        try {
            reifier.reifyAs(node, TestReifier.triple("x R z"));
            TestReifier.fail((String)"did not detected already reified node");
        }
        catch (Reifier.AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

